/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.nico;

import com.sedmelluq.discord.lavaplayer.container.mpeg.MpegAudioTrack;
import com.sedmelluq.discord.lavaplayer.source.AudioSourceManager;
import com.sedmelluq.discord.lavaplayer.source.nico.HeartbeatingHttpStream;
import com.sedmelluq.discord.lavaplayer.source.nico.NicoAudioSourceManager;
import com.sedmelluq.discord.lavaplayer.tools.DataFormatTools;
import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.track.AudioTrack;
import com.sedmelluq.discord.lavaplayer.track.AudioTrackInfo;
import com.sedmelluq.discord.lavaplayer.track.DelegatedAudioTrack;
import com.sedmelluq.discord.lavaplayer.track.playback.LocalAudioTrackExecutor;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.json.JSONArray;
import org.json.JSONObject;
import org.jsoup.parser.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NicoAudioTrack
extends DelegatedAudioTrack {
    private static final Logger log = LoggerFactory.getLogger(NicoAudioTrack.class);
    private static String actionTrackId = "S1G2fKdzOl_1702504390263";
    private final NicoAudioSourceManager sourceManager;
    private String heartbeatUrl;
    private int heartbeatIntervalMs;
    private String initialHeartbeatPayload;

    public NicoAudioTrack(AudioTrackInfo trackInfo, NicoAudioSourceManager sourceManager) {
        super(trackInfo);
        this.sourceManager = sourceManager;
    }

    @Override
    public void process(LocalAudioTrackExecutor localExecutor) throws Exception {
        try (HttpInterface httpInterface = this.sourceManager.getHttpInterface();){
            String playbackUrl = this.loadPlaybackUrl(httpInterface);
            log.debug("Starting NicoNico track from URL: {}", (Object)playbackUrl);
            try (HeartbeatingHttpStream stream = new HeartbeatingHttpStream(httpInterface, new URI(playbackUrl), null, this.heartbeatUrl, this.heartbeatIntervalMs, this.initialHeartbeatPayload);){
                this.processDelegate(new MpegAudioTrack(this.trackInfo, stream), localExecutor);
            }
        }
    }

    private JsonBrowser loadVideoApi(HttpInterface httpInterface) throws IOException {
        String apiUrl = "https://www.nicovideo.jp/api/watch/v3_guest/" + this.getIdentifier() + "?_frontendId=6&_frontendVersion=0&actionTrackId=" + actionTrackId + "&i18nLanguage=en-us";
        try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet(apiUrl));){
            HttpClientTools.assertSuccessWithContent((HttpResponse)response, "api response");
            JsonBrowser jsonBrowser = JsonBrowser.parse(response.getEntity().getContent()).get("data");
            return jsonBrowser;
        }
    }

    private JsonBrowser loadVideoMainPage(HttpInterface httpInterface) throws IOException {
        try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)new HttpGet(this.trackInfo.uri));){
            HttpClientTools.assertSuccessWithContent((HttpResponse)response, "video main page");
            String urlEncodedData = DataFormatTools.extractBetween(EntityUtils.toString((HttpEntity)response.getEntity()), "data-api-data=\"", "\"");
            String watchData = Parser.unescapeEntities((String)urlEncodedData, (boolean)false);
            JsonBrowser jsonBrowser = JsonBrowser.parse(watchData);
            return jsonBrowser;
        }
    }

    private String loadPlaybackUrl(HttpInterface httpInterface) throws IOException {
        String trackingId;
        JsonBrowser videoJson = this.loadVideoApi(httpInterface);
        if (videoJson.isNull()) {
            log.warn("Couldn't retrieve NicoNico video details from API, falling back to HTML page...");
            videoJson = this.loadVideoMainPage(httpInterface);
        }
        if (!videoJson.isNull() && (trackingId = videoJson.get("client").get("watchTrackId").text()) != null) {
            actionTrackId = trackingId;
        }
        JSONObject watchData = this.processJSON(videoJson.get("media").get("delivery").get("movie").get("session"));
        HttpPost request = new HttpPost("https://api.dmc.nico/api/sessions?_format=json");
        request.addHeader("Host", "api.dmc.nico");
        request.addHeader("Connection", "keep-alive");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Origin", "https://www.nicovideo.jp");
        request.setEntity((HttpEntity)new StringEntity(watchData.toString()));
        try (CloseableHttpResponse response = httpInterface.execute((HttpUriRequest)request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 201) {
                throw new IOException("Unexpected status code from playback parameters page: " + statusCode);
            }
            JsonBrowser info = JsonBrowser.parse(response.getEntity().getContent()).get("data");
            JsonBrowser session = info.get("session");
            this.heartbeatUrl = "https://api.dmc.nico/api/sessions/" + session.get("id").text() + "?_format=json&_method=PUT";
            this.heartbeatIntervalMs = session.get("keep_method").get("heartbeat").get("lifetime").asInt(120000) - 5000;
            this.initialHeartbeatPayload = info.format();
            String string = session.get("content_uri").text();
            return string;
        }
    }

    private JSONObject processJSON(JsonBrowser input) {
        if (input.isNull()) {
            throw new IllegalStateException("Invalid response received from NicoNico when loading video details");
        }
        JSONObject lifetime = new JSONObject().put("lifetime", input.get("heartbeatLifetime").asLong(120000L));
        JSONObject heartbeat = new JSONObject().put("heartbeat", (Object)lifetime);
        List videos = input.get("videos").values().stream().map(JsonBrowser::text).collect(Collectors.toList());
        List audios = input.get("audios").values().stream().map(JsonBrowser::text).collect(Collectors.toList());
        JSONObject srcIds = new JSONObject().put("video_src_ids", videos).put("audio_src_ids", audios);
        JSONObject srcIdToMux = new JSONObject().put("src_id_to_mux", (Object)srcIds);
        JSONArray array = new JSONArray().put((Object)srcIdToMux);
        JSONObject contentSrcIds = new JSONObject().put("content_src_ids", (Object)array);
        JSONArray contentSrcIdSets = new JSONArray().put((Object)contentSrcIds);
        JsonBrowser url = input.get("urls").index(0);
        boolean useWellKnownPort = url.get("isWellKnownPort").asBoolean(false);
        boolean useSsl = url.get("isSsl").asBoolean(false);
        JSONObject httpDownloadParameters = new JSONObject().put("use_well_known_port", (Object)(useWellKnownPort ? "yes" : "no")).put("use_ssl", (Object)(useSsl ? "yes" : "no"));
        JSONObject innerParameters = new JSONObject().put("http_output_download_parameters", (Object)httpDownloadParameters);
        JSONObject httpParameters = new JSONObject().put("parameters", (Object)innerParameters);
        JSONObject outerParameters = new JSONObject().put("http_parameters", (Object)httpParameters);
        JSONObject protocol = new JSONObject().put("name", (Object)"http").put("parameters", (Object)outerParameters);
        JSONObject sessionOperationAuthBySignature = new JSONObject().put("token", (Object)input.get("token").text()).put("signature", (Object)input.get("signature").text());
        JSONObject sessionOperationAuth = new JSONObject().put("session_operation_auth_by_signature", (Object)sessionOperationAuthBySignature);
        JSONObject contentAuth = new JSONObject().put("auth_type", (Object)input.get("authTypes").get("http").text()).put("content_key_timeout", input.get("contentKeyTimeout").asLong(120000L)).put("service_id", (Object)"nicovideo").put("service_user_id", (Object)input.get("serviceUserId").text());
        JSONObject clientInfo = new JSONObject().put("player_id", (Object)input.get("playerId").text());
        JSONObject session = new JSONObject().put("content_type", (Object)"movie").put("timing_constraint", (Object)"unlimited").put("recipe_id", (Object)input.get("recipeId").text()).put("content_id", (Object)input.get("contentId").text()).put("keep_method", (Object)heartbeat).put("content_src_id_sets", (Object)contentSrcIdSets).put("protocol", (Object)protocol).put("session_operation_auth", (Object)sessionOperationAuth).put("content_auth", (Object)contentAuth).put("client_info", (Object)clientInfo);
        return new JSONObject().put("session", (Object)session);
    }

    @Override
    protected AudioTrack makeShallowClone() {
        return new NicoAudioTrack(this.trackInfo, this.sourceManager);
    }

    @Override
    public AudioSourceManager getSourceManager() {
        return this.sourceManager;
    }
}

