/*
 * Decompiled with CFR 0.152.
 */
package com.sedmelluq.discord.lavaplayer.source.nico;

import com.sedmelluq.discord.lavaplayer.tools.JsonBrowser;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpClientTools;
import com.sedmelluq.discord.lavaplayer.tools.io.HttpInterface;
import com.sedmelluq.discord.lavaplayer.tools.io.PersistentHttpStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeartbeatingHttpStream
extends PersistentHttpStream {
    private static final Logger log = LoggerFactory.getLogger(HeartbeatingHttpStream.class);
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private String heartbeatUrl;
    private int heartbeatInterval;
    private String heartbeatPayload;
    private ScheduledFuture<?> heartbeatFuture;

    public HeartbeatingHttpStream(HttpInterface httpInterface, URI contentUrl, Long contentLength, String heartbeatUrl, int heartbeatInterval, String heartbeatPayload) {
        super(httpInterface, contentUrl, contentLength);
        this.heartbeatUrl = heartbeatUrl;
        this.heartbeatInterval = heartbeatInterval;
        this.heartbeatPayload = heartbeatPayload;
        this.setupHeartbeat();
    }

    protected void setupHeartbeat() {
        log.debug("Heartbeat every {} milliseconds to URL: {}", (Object)this.heartbeatInterval, (Object)this.heartbeatUrl);
        this.heartbeatFuture = executor.scheduleAtFixedRate(() -> {
            try {
                this.sendHeartbeat();
            }
            catch (Throwable t) {
                log.error("Heartbeat error!", t);
                IOUtils.closeQuietly((InputStream)this);
            }
        }, this.heartbeatInterval, this.heartbeatInterval, TimeUnit.MILLISECONDS);
    }

    protected void sendHeartbeat() throws IOException {
        HttpPost request = new HttpPost(this.heartbeatUrl);
        request.addHeader("Host", "api.dmc.nico");
        request.addHeader("Connection", "keep-alive");
        request.addHeader("Content-Type", "application/json");
        request.addHeader("Origin", "https://www.nicovideo.jp");
        request.setEntity((HttpEntity)new StringEntity(this.heartbeatPayload));
        try (CloseableHttpResponse response = this.httpInterface.execute((HttpUriRequest)request);){
            HttpClientTools.assertSuccessWithContent((HttpResponse)response, "heartbeat page");
            this.heartbeatPayload = JsonBrowser.parse(response.getEntity().getContent()).get("data").format();
        }
    }

    @Override
    public void close() throws IOException {
        this.heartbeatFuture.cancel(false);
        super.close();
    }
}

