/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.util;

import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.Server;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ServerUtil {
    private static final String CONSOLE_SENDER_ID = "*console*";
    @Autowired
    private Server server;

    public String getSenderId(CommandSender sender) {
        if (sender == null) {
            return null;
        }
        if (sender instanceof ConsoleCommandSender) {
            return CONSOLE_SENDER_ID;
        }
        if (!(sender instanceof OfflinePlayer)) {
            return null;
        }
        OfflinePlayer player = (OfflinePlayer)sender;
        return this.server.getOnlineMode() ? player.getUniqueId().toString() : StringUtils.lowerCase((String)player.getName());
    }

    public CommandSender getSenderFromId(String id) {
        if (id == null) {
            return null;
        }
        if (CONSOLE_SENDER_ID.equals(id)) {
            return this.server.getConsoleSender();
        }
        if (id.length() <= 16) {
            return this.server.getPlayer(id);
        }
        return this.server.getPlayer(UUID.fromString(id));
    }
}

