/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.util.ClassUtils;

public class AopAnnotationUtils {
    private static final Map<Class<?>, Map<Method, List<Annotation>>> annotationCache = new ConcurrentHashMap();

    private AopAnnotationUtils() {
    }

    public static <T extends Annotation> List<T> getAppliableAnnotations(Method method, Class<T> annotation) {
        Map methodCache = annotationCache.computeIfAbsent(annotation, a -> new ConcurrentHashMap());
        List annotations = methodCache.computeIfAbsent(method, m -> {
            Class declaringClass = ClassUtils.getUserClass(method.getDeclaringClass());
            Set methodAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)method, (Class)annotation);
            Set classAnnotations = AnnotatedElementUtils.findAllMergedAnnotations((AnnotatedElement)declaringClass, (Class)annotation);
            return Collections.unmodifiableList(Stream.concat(classAnnotations.stream(), methodAnnotations.stream()).collect(Collectors.toList()));
        });
        return annotations;
    }
}

