/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.security;

import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.context.SessionService;
import dev.alangomes.springspigot.exception.PermissionDeniedException;
import dev.alangomes.springspigot.exception.PlayerNotFoundException;
import dev.alangomes.springspigot.security.Audit;
import dev.alangomes.springspigot.security.Authorize;
import dev.alangomes.springspigot.security.GuardService;
import dev.alangomes.springspigot.util.AopAnnotationUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

@Aspect
@Component
@Scope(value="singleton")
class SecurityAspect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SecurityAspect.class);
    @Autowired
    private Context context;
    @Autowired
    private SessionService sessionService;
    @Autowired(required=false)
    private GuardService guardService;
    private final Map<String, Expression> expressionCache = new ConcurrentHashMap<String, Expression>();
    private final ExpressionParser parser = new SpelExpressionParser();

    SecurityAspect() {
    }

    @Order(value=0)
    @Around(value="within(@(@dev.alangomes.springspigot.security.Authorize *) *) || execution(@(@dev.alangomes.springspigot.security.Authorize *) * *(..)) || @within(dev.alangomes.springspigot.security.Authorize)|| execution(@dev.alangomes.springspigot.security.Authorize * *(..))")
    public Object checkPermission(ProceedingJoinPoint joinPoint) throws Throwable {
        CommandSender sender = this.context.getSender();
        if (sender == null) {
            throw new PlayerNotFoundException();
        }
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        StandardEvaluationContext senderContext = new StandardEvaluationContext((Object)sender);
        Parameter[] parameters = method.getParameters();
        IntStream.range(0, parameters.length).forEach(i -> senderContext.setVariable(parameters[i].getName(), joinPoint.getArgs()[i]));
        senderContext.setVariable("session", this.sessionService.current());
        senderContext.setVariable("guard", (Object)this.guardService);
        AopAnnotationUtils.getAppliableAnnotations(method, Authorize.class).forEach(authorize -> {
            String expressionSource = authorize.value();
            Expression expression = this.expressionCache.computeIfAbsent(expressionSource, arg_0 -> ((ExpressionParser)this.parser).parseExpression(arg_0));
            senderContext.setVariable("params", (Object)authorize.params());
            if (!BooleanUtils.toBoolean((Boolean)((Boolean)expression.getValue((EvaluationContext)senderContext, Boolean.class)))) {
                String message = StringUtils.trimToNull((String)ChatColor.translateAlternateColorCodes((char)'&', (String)authorize.message()));
                throw new PermissionDeniedException(expressionSource, message);
            }
        });
        return joinPoint.proceed();
    }

    @Order(value=1)
    @Before(value="within(@(@dev.alangomes.springspigot.security.Audit *) *) || execution(@(@dev.alangomes.springspigot.security.Audit *) * *(..)) || @within(dev.alangomes.springspigot.security.Audit)|| execution(@dev.alangomes.springspigot.security.Audit * *(..))")
    public void auditCall(JoinPoint joinPoint) {
        CommandSender sender = this.context.getSender();
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        String signature = ClassUtils.getUserClass(method.getDeclaringClass()).getName() + "." + method.getName();
        String arguments = Arrays.stream(joinPoint.getArgs()).map(String::valueOf).collect(Collectors.joining(", "));
        AopAnnotationUtils.getAppliableAnnotations(method, Audit.class).stream().filter(audit -> sender != null || !audit.senderOnly()).limit(1L).forEach(audit -> {
            if (sender != null) {
                log.info(String.format("Player %s invoked %s(%s)", sender.getName(), signature, arguments));
            } else {
                log.info(String.format("Server invoked %s(%s)", signature, arguments));
            }
        });
    }
}

