/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.scope;

import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.scope.NullSender;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.permissions.Permissible;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.stereotype.Component;

@Component
@org.springframework.context.annotation.Scope(value="singleton")
public class SenderContextScope
implements Scope,
Listener {
    private static final NullSender NULL_SENDER = new NullSender();
    private final Map<Permissible, Map<String, Object>> senderScope = new ConcurrentHashMap<Permissible, Map<String, Object>>();
    private final Map<Permissible, Map<String, Runnable>> destructionCallbacks = new ConcurrentHashMap<Permissible, Map<String, Runnable>>();

    public Object get(String name, ObjectFactory<?> objectFactory) {
        if (Context.getInstance() == null) {
            return null;
        }
        Map<String, Object> scope = this.getCurrentScope();
        return scope.computeIfAbsent(name, n -> objectFactory.getObject());
    }

    public Object remove(String name) {
        if (Context.getInstance() == null) {
            return null;
        }
        Map<String, Object> scope = this.getCurrentScope();
        Map<String, Runnable> callbacks = this.getDestructionCallbacks();
        Object removed = scope.remove(name);
        callbacks.remove(name).run();
        return removed;
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        if (Context.getInstance() == null) {
            return;
        }
        Map<String, Runnable> callbacks = this.getDestructionCallbacks();
        callbacks.put(name, callback);
    }

    public Object resolveContextualObject(String key) {
        return null;
    }

    public String getConversationId() {
        return "sender";
    }

    private Map<String, Object> getCurrentScope() {
        Permissible sender = this.getCurrentSender();
        return this.senderScope.computeIfAbsent(sender, s -> new ConcurrentHashMap());
    }

    private Map<String, Runnable> getDestructionCallbacks() {
        Permissible sender = this.getCurrentSender();
        return this.destructionCallbacks.computeIfAbsent(sender, s -> new ConcurrentHashMap());
    }

    private Permissible getCurrentSender() {
        CommandSender sender = Context.getInstance().getSender();
        return sender != null ? sender : NULL_SENDER;
    }

    public void clear() {
        if (Context.getInstance() == null) {
            return;
        }
        Permissible sender = this.getCurrentSender();
        this.senderScope.remove(sender);
        Map<String, Runnable> callbacks = this.destructionCallbacks.remove(sender);
        if (callbacks != null) {
            callbacks.values().forEach(Runnable::run);
        }
    }

    @EventHandler
    void onQuit(PlayerQuitEvent event) {
        this.clear();
    }
}

