/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.reactive;

import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.reactive.EventEmitter;
import dev.alangomes.springspigot.reactive.ObserveEvent;
import io.reactivex.Observable;
import io.reactivex.disposables.CompositeDisposable;
import javax.annotation.PreDestroy;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;

@Configuration
@ConditionalOnClass(value={Observable.class})
class ReactiveConfiguration {
    private CompositeDisposable compositeDisposable = new CompositeDisposable();

    ReactiveConfiguration() {
    }

    @Scope(value="prototype")
    @Bean
    public <T extends Event> Observable<T> eventObservable(InjectionPoint injectionPoint, Plugin plugin, Context context) {
        ObserveEvent observeEvent = (ObserveEvent)injectionPoint.getAnnotation(ObserveEvent.class);
        if (observeEvent == null) {
            return null;
        }
        ResolvableType eventType = ((DependencyDescriptor)injectionPoint).getResolvableType().getGeneric(new int[]{0});
        EventEmitter eventEmitter = new EventEmitter(eventType.getRawClass(), observeEvent, plugin, context);
        return Observable.create(eventEmitter).doOnSubscribe(arg_0 -> ((CompositeDisposable)this.compositeDisposable).add(arg_0)).doOnDispose(() -> HandlerList.unregisterAll((Listener)eventEmitter.getListener()));
    }

    @PreDestroy
    void destroy() {
        this.compositeDisposable.dispose();
    }
}

