/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.reactive;

import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.event.EventUtil;
import dev.alangomes.springspigot.reactive.ObserveEvent;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import lombok.Generated;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

class EventEmitter<T extends Event>
implements ObservableOnSubscribe<T> {
    private final Listener listener = new Listener(){};
    private final Class<? extends Event> eventClazz;
    private final ObserveEvent observeEvent;
    private final Plugin plugin;
    private final Context context;

    public void subscribe(ObservableEmitter<T> observableEmitter) {
        PluginManager pluginManager = this.plugin.getServer().getPluginManager();
        pluginManager.registerEvent(this.eventClazz, this.listener, this.observeEvent.priority(), (l, event) -> {
            if (this.eventClazz.isAssignableFrom(event.getClass())) {
                Event emittedEvent = event;
                this.context.runWithSender(EventUtil.getSender(emittedEvent), () -> observableEmitter.onNext((Object)emittedEvent));
            }
        }, this.plugin, this.observeEvent.ignoreCancelled());
    }

    @Generated
    public EventEmitter(Class<? extends Event> eventClazz, ObserveEvent observeEvent, Plugin plugin, Context context) {
        this.eventClazz = eventClazz;
        this.observeEvent = observeEvent;
        this.plugin = plugin;
        this.context = context;
    }

    @Generated
    public Listener getListener() {
        return this.listener;
    }
}

