/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.picocli.conversion;

import dev.alangomes.springspigot.picocli.conversion.ConverterRegistryDecorator;
import java.lang.reflect.Field;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionService;
import org.springframework.stereotype.Service;
import picocli.CommandLine;

@Service
public class PicocliConversorInjector {
    @Autowired
    private ConversionService conversionService;

    public void injectConversor(CommandLine commandLine) {
        Field interpreterField = CommandLine.class.getDeclaredField("interpreter");
        interpreterField.setAccessible(true);
        Object interpreter = interpreterField.get(commandLine);
        Class<?> interpreterClass = interpreterField.getType();
        Field registryField = interpreterClass.getDeclaredField("converterRegistry");
        registryField.setAccessible(true);
        this.removeFinal(registryField);
        Object originalRegistry = registryField.get(interpreter);
        if (!(originalRegistry instanceof ConverterRegistryDecorator)) {
            registryField.set(interpreter, new ConverterRegistryDecorator((Map)originalRegistry, this.conversionService));
        }
        commandLine.getSubcommands().values().forEach(this::injectConversor);
    }

    private void removeFinal(Field field) {
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
    }
}

