/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.picocli;

import dev.alangomes.springspigot.command.Subcommand;
import dev.alangomes.springspigot.picocli.BaseCommand;
import dev.alangomes.springspigot.picocli.CommandLineDefinition;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import picocli.CommandLine;

@Configuration
@Scope(value="singleton")
class PicocliConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PicocliConfiguration.class);

    PicocliConfiguration() {
    }

    @Bean
    CommandLineDefinition picocliCommandLine(ApplicationContext applicationContext, CommandLine.IFactory factory) {
        List<String> commands = Arrays.stream(applicationContext.getBeanNamesForAnnotation(CommandLine.Command.class)).filter(name -> !this.isSubcommand((BeanFactory)applicationContext, (String)name)).collect(Collectors.toList());
        List<String> mainCommands = this.getMainCommands(commands, applicationContext);
        Object mainCommand = mainCommands.isEmpty() ? new BaseCommand() : mainCommands.get(0);
        commands.removeAll(mainCommands);
        CommandLineDefinition cli = new CommandLineDefinition(mainCommand, factory);
        this.registerCommands(cli, commands, applicationContext, factory);
        return cli;
    }

    private boolean isSubcommand(BeanFactory beanFactory, String beanName) {
        Class<?> type = this.getType(beanFactory, beanName);
        return AnnotationUtils.findAnnotation(type, Subcommand.class) != null;
    }

    private String getCommandName(String command, ApplicationContext applicationContext) {
        if (command == null) {
            return null;
        }
        return this.getType((BeanFactory)applicationContext, command).getAnnotation(CommandLine.Command.class).name();
    }

    private String getCommandName(Class<?> commandClass) {
        if (commandClass == null) {
            return null;
        }
        return commandClass.getAnnotation(CommandLine.Command.class).name();
    }

    private List<String> getMainCommands(Collection<String> candidates, ApplicationContext context) {
        ArrayList<String> mainCommands = new ArrayList<String>();
        for (String candidate : candidates) {
            Class<?> clazz = this.getType((BeanFactory)context, candidate);
            Method method = ReflectionUtils.findMethod(CommandLine.Command.class, (String)"name");
            if (!clazz.isAnnotationPresent(CommandLine.Command.class) || method == null || !clazz.getAnnotation(CommandLine.Command.class).name().equals(method.getDefaultValue())) continue;
            mainCommands.add(candidate);
        }
        return mainCommands;
    }

    private int getNestedLevel(Class clazz) {
        int level = 0;
        Class<?> parent = clazz.getEnclosingClass();
        while (parent != null && parent.isAnnotationPresent(CommandLine.Command.class)) {
            parent = parent.getEnclosingClass();
            ++level;
        }
        return level;
    }

    private Optional<Class> getParentClass(Class clazz) {
        Class<?> parentClass = clazz.getEnclosingClass();
        if (parentClass == null || !parentClass.isAnnotationPresent(CommandLine.Command.class)) {
            return Optional.empty();
        }
        return Optional.of(parentClass);
    }

    private Map<Node, List<String>> findCommands(Collection<String> commands, ApplicationContext applicationContext) {
        LinkedHashMap<Node, List<String>> tree = new LinkedHashMap<Node, List<String>>();
        commands.stream().filter(o -> this.getType((BeanFactory)applicationContext, (String)o) != null).sorted((o1, o2) -> {
            int l1 = this.getNestedLevel(this.getType((BeanFactory)applicationContext, (String)o1));
            int l2 = this.getNestedLevel(this.getType((BeanFactory)applicationContext, (String)o2));
            return Integer.compare(l1, l2);
        }).forEach(o -> {
            Class<?> clazz = this.getType((BeanFactory)applicationContext, (String)o);
            Optional<Class> parentClass = this.getParentClass(clazz);
            parentClass.ifPresent(c -> {
                List objects = (List)tree.get(new Node((Class<?>)c, null, null));
                if (objects != null) {
                    objects.add(o);
                }
            });
            tree.put(new Node(clazz, (String)o, parentClass.orElse(null)), new ArrayList());
        });
        return tree;
    }

    private void registerCommands(CommandLineDefinition cli, Collection<String> commands, ApplicationContext applicationContext, CommandLine.IFactory factory) {
        CommandLineDefinition current = cli;
        HashMap parents = new HashMap();
        for (Map.Entry<Node, List<String>> entry : this.findCommands(commands, applicationContext).entrySet()) {
            Node node = entry.getKey();
            if (node.getParent() != null && !node.getParent().equals(this.getType((BeanFactory)applicationContext, current.getBeanName()))) continue;
            List<String> children = entry.getValue();
            String command = node.getBeanName();
            String commandName = this.getCommandName(node.getClazz());
            if (StringUtils.isBlank((String)commandName)) continue;
            if (parents.containsKey(node.getParent())) {
                current = (CommandLineDefinition)parents.get(node.getParent());
            } else if (node.getParent() == null) {
                current = cli;
            }
            if (children.isEmpty()) {
                current.addSubcommand(commandName, command);
            } else {
                CommandLineDefinition sub = new CommandLineDefinition(command, factory);
                current.addSubcommand(commandName, sub);
                for (String child : children) {
                    sub.addSubcommand(this.getCommandName(child, applicationContext), new CommandLineDefinition(child, factory));
                }
                current = sub;
            }
            parents.put(node.getClazz(), current);
        }
    }

    private Class<?> getType(BeanFactory beanFactory, String beanName) {
        return ClassUtils.getUserClass((Class)beanFactory.getType(beanName));
    }

    private static class Node {
        private final Class<?> clazz;
        private final String beanName;
        private final Class<?> parent;

        Node(Class<?> clazz, String beanName, Class<?> parent) {
            this.clazz = clazz;
            this.beanName = beanName;
            this.parent = parent;
        }

        Class<?> getClazz() {
            return this.clazz;
        }

        String getBeanName() {
            return this.beanName;
        }

        Class<?> getParent() {
            return this.parent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node node = (Node)o;
            return this.clazz != null ? this.clazz.equals(node.clazz) : node.clazz == null;
        }

        public int hashCode() {
            return this.clazz != null ? this.clazz.hashCode() : 0;
        }
    }
}

