/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.event;

import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.event.EventUtil;
import java.lang.reflect.Method;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SpringEventExecutor {
    @Autowired
    private Context context;

    public EventExecutor create(Method method) {
        Class<?> eventType = method.getParameters()[0].getType();
        return (listener, event) -> {
            if (!eventType.isInstance(event)) {
                return;
            }
            this.context.runWithSender(EventUtil.getSender(event), () -> this.triggerEvent(method, listener, event));
        };
    }

    private void triggerEvent(Method method, Listener listener, Event event) {
        AopUtils.invokeJoinpointUsingReflection((Object)listener, (Method)method, (Object[])new Object[]{event});
    }
}

