/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.context;

import dev.alangomes.springspigot.context.Context;
import dev.alangomes.springspigot.context.SessionService;
import dev.alangomes.springspigot.util.ServerUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class DefaultSessionService
implements SessionService,
Listener {
    @Autowired
    private Context context;
    @Autowired
    private ServerUtil serverUtil;
    private final Map<String, Map<String, Object>> sessions = new ConcurrentHashMap<String, Map<String, Object>>();

    @Override
    public Map<String, Object> current() {
        return this.of(this.context.getSender());
    }

    @Override
    public Map<String, Object> of(CommandSender sender) {
        String senderId = this.serverUtil.getSenderId(sender);
        if (senderId == null) {
            return null;
        }
        return this.sessions.computeIfAbsent(senderId, k -> new ConcurrentHashMap());
    }

    @EventHandler
    private void onQuit(PlayerQuitEvent event) {
        String senderId = this.serverUtil.getSenderId((CommandSender)event.getPlayer());
        this.sessions.remove(senderId);
    }
}

