/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.context;

import dev.alangomes.springspigot.util.ServerUtil;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import lombok.Generated;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="singleton")
public class Context {
    private static Context instance;
    @Autowired
    private ServerUtil serverUtil;
    private final Map<Long, String> senderRefs = new ConcurrentHashMap<Long, String>();

    @PostConstruct
    void init() {
        instance = this;
    }

    @PreDestroy
    void destroy() {
        instance = null;
    }

    void setSender(CommandSender sender) {
        long threadId = Thread.currentThread().getId();
        if (sender == null) {
            this.senderRefs.remove(threadId);
            return;
        }
        this.senderRefs.put(threadId, this.serverUtil.getSenderId(sender));
    }

    public Player getPlayer() {
        CommandSender sender = this.getSender();
        return sender instanceof Player ? (Player)sender : null;
    }

    public CommandSender getSender() {
        String senderRef = this.senderRefs.get(Thread.currentThread().getId());
        return this.serverUtil.getSenderFromId(senderRef);
    }

    public String getSenderId() {
        return this.serverUtil.getSenderId(this.getSender());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, S extends CommandSender> T runWithSender(S sender, Function<S, T> function) {
        CommandSender oldSender = this.getSender();
        this.setSender(sender);
        try {
            T t = function.apply(sender);
            return t;
        }
        finally {
            this.setSender(oldSender);
        }
    }

    public <T, S extends CommandSender> T runWithSender(S sender, Supplier<T> supplier) {
        return (T)this.runWithSender(sender, (S s) -> supplier.get());
    }

    public <S extends CommandSender> void runWithSender(S sender, Consumer<S> function) {
        this.runWithSender(sender, (S s) -> {
            function.accept(s);
            return null;
        });
    }

    public <S extends CommandSender> void runWithSender(S sender, Runnable runnable) {
        this.runWithSender(sender, (S s) -> {
            runnable.run();
            return null;
        });
    }

    public <T> Supplier<T> wrap(Supplier<T> supplier) {
        String senderId = this.getSenderId();
        return () -> this.runWithSender(this.serverUtil.getSenderFromId(senderId), supplier);
    }

    public <T> Callable<T> wrap(Callable<T> callable) {
        String senderId = this.getSenderId();
        return () -> this.runWithSender(this.serverUtil.getSenderFromId(senderId), () -> this.call(callable));
    }

    private <V> V call(Callable<V> callable) {
        return callable.call();
    }

    public Runnable wrap(Runnable runnable) {
        String senderId = this.getSenderId();
        return () -> this.runWithSender(this.serverUtil.getSenderFromId(senderId), runnable);
    }

    public <T> Consumer<T> wrap(Consumer<T> consumer) {
        String senderId = this.getSenderId();
        return v -> this.runWithSender(this.serverUtil.getSenderFromId(senderId), () -> consumer.accept(v));
    }

    public <T, R> Function<T, R> wrap(Function<T, R> function) {
        String senderId = this.getSenderId();
        return v -> this.runWithSender(this.serverUtil.getSenderFromId(senderId), () -> function.apply(v));
    }

    @Generated
    public static Context getInstance() {
        return instance;
    }
}

