/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.configuration;

import dev.alangomes.springspigot.configuration.DynamicValue;
import dev.alangomes.springspigot.configuration.Instance;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.springframework.beans.factory.InjectionPoint;
import org.springframework.beans.factory.config.DependencyDescriptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.env.Environment;

@Configuration
class ResourceConfiguration {
    ResourceConfiguration() {
    }

    @Scope(value="prototype")
    @Bean
    public Instance configInstance(InjectionPoint injectionPoint, ConversionService conversionService, Environment environment) {
        DynamicValue dynamicValue = (DynamicValue)injectionPoint.getAnnotation(DynamicValue.class);
        ResolvableType type = ((DependencyDescriptor)injectionPoint).getResolvableType().getGeneric(new int[]{0});
        return new Instance(environment, dynamicValue.value(), conversionService, type.getRawClass());
    }

    @Bean
    public ConversionService conversionService() {
        DefaultConversionService conversionService = new DefaultConversionService();
        conversionService.addConverter(ConfigurationSection.class, Map.class, s -> s.getValues(true));
        return conversionService;
    }
}

