/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot.command;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;

public final class CommandResult {
    private static final CommandResult UNKNOWN_COMMAND = new CommandResult(null, false, false);
    private final boolean errored;
    private final boolean exists;
    private final List<String> output;

    private CommandResult(Collection<String> output, boolean errored, boolean exists) {
        this.errored = errored;
        this.exists = exists;
        this.output = output != null ? Collections.unmodifiableList(new LinkedList<String>(output)) : Collections.emptyList();
    }

    public CommandResult(Collection<String> output) {
        this(output, false, true);
    }

    public CommandResult(String output, boolean errored) {
        this(Collections.singletonList(output), errored, true);
    }

    public static CommandResult unknown() {
        return UNKNOWN_COMMAND;
    }

    @Generated
    public boolean isErrored() {
        return this.errored;
    }

    @Generated
    public boolean isExists() {
        return this.exists;
    }

    @Generated
    public List<String> getOutput() {
        return this.output;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandResult)) {
            return false;
        }
        CommandResult other = (CommandResult)o;
        if (this.isErrored() != other.isErrored()) {
            return false;
        }
        if (this.isExists() != other.isExists()) {
            return false;
        }
        List<String> this$output = this.getOutput();
        List<String> other$output = other.getOutput();
        return !(this$output == null ? other$output != null : !((Object)this$output).equals(other$output));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isErrored() ? 79 : 97);
        result = result * 59 + (this.isExists() ? 79 : 97);
        List<String> $output = this.getOutput();
        result = result * 59 + ($output == null ? 43 : ((Object)$output).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CommandResult(errored=" + this.isErrored() + ", exists=" + this.isExists() + ", output=" + this.getOutput() + ")";
    }
}

