/*
 * Decompiled with CFR 0.152.
 */
package dev.alangomes.springspigot;

import dev.alangomes.springspigot.scope.SenderContextScope;
import java.util.Arrays;
import org.bukkit.event.Listener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;

class ScopePostProcessor
implements BeanFactoryPostProcessor {
    private SenderContextScope senderContextScope;

    ScopePostProcessor(SenderContextScope senderContextScope) {
        this.senderContextScope = senderContextScope;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory factory) throws BeansException {
        factory.registerScope("sender", (Scope)this.senderContextScope);
        Arrays.stream(factory.getBeanDefinitionNames()).forEach(beanName -> {
            BeanDefinition beanDef = factory.getBeanDefinition(beanName);
            Class beanType = factory.getType(beanName);
            if (beanType != null && beanType.isAssignableFrom(Listener.class)) {
                beanDef.setScope("singleton");
            }
        });
    }
}

