/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.node.ValueNode;
import de.undercouch.bson4jackson.BsonParser;
import de.undercouch.bson4jackson.types.ObjectId;
import java.io.IOException;

public class BsonObjectIdDeserializer
extends JsonDeserializer<ObjectId> {
    private final boolean useLegacyFormat;

    public BsonObjectIdDeserializer() {
        this(false);
    }

    @Deprecated
    public BsonObjectIdDeserializer(boolean useLegacyFormat) {
        this.useLegacyFormat = useLegacyFormat;
    }

    public ObjectId deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 7) {
                throw ctxt.mappingException(ObjectId.class);
            }
            return (ObjectId)bsonParser.getEmbeddedObject();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof ObjectId) {
            return (ObjectId)jp.getEmbeddedObject();
        }
        TreeNode tree = jp.getCodec().readTree(jp);
        if (this.useLegacyFormat) {
            int time = ((ValueNode)tree.get("$time")).asInt();
            int machine = ((ValueNode)tree.get("$machine")).asInt();
            int inc = ((ValueNode)tree.get("$inc")).asInt();
            return new ObjectId(time, machine, inc);
        }
        int timestamp = ((ValueNode)tree.get("$timestamp")).asInt();
        int randomValue1 = ((ValueNode)tree.get("$randomValue1")).asInt();
        short randomValue2 = (short)((ValueNode)tree.get("$randomValue2")).asInt();
        int counter = ((ValueNode)tree.get("$counter")).asInt();
        return new ObjectId(timestamp, counter, randomValue1, randomValue2);
    }
}

