/*
 * Decompiled with CFR 0.152.
 */
package de.undercouch.bson4jackson;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.core.base.GeneratorBase;
import com.fasterxml.jackson.core.io.CharacterEscapes;
import com.fasterxml.jackson.databind.SerializerProvider;
import de.undercouch.bson4jackson.io.ByteOrderUtil;
import de.undercouch.bson4jackson.io.DynamicOutputBuffer;
import de.undercouch.bson4jackson.types.Decimal128;
import de.undercouch.bson4jackson.types.JavaScript;
import de.undercouch.bson4jackson.types.ObjectId;
import de.undercouch.bson4jackson.types.Symbol;
import de.undercouch.bson4jackson.types.Timestamp;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;

public class BsonGenerator
extends GeneratorBase {
    protected final int _bsonFeatures;
    protected final OutputStream _out;
    protected final DynamicOutputBuffer _buffer = new DynamicOutputBuffer(ByteOrder.LITTLE_ENDIAN);
    protected int _typeMarker = 0;
    protected DocumentInfo _currentDocument;
    protected boolean nextObjectIsEmbeddedInValue = false;
    protected CharacterEscapes _characterEscapes = null;
    protected int[] _outputEscapes = null;

    public BsonGenerator(int jsonFeatures, int bsonFeatures, OutputStream out) {
        super(jsonFeatures, null);
        this._bsonFeatures = bsonFeatures;
        this._out = out;
        if (this.isEnabled(Feature.ENABLE_STREAMING)) {
            this._buffer.setReuseBuffersCount(2);
        }
    }

    public JsonGenerator setCharacterEscapes(CharacterEscapes esc) {
        this._characterEscapes = esc;
        this._outputEscapes = (int[])(esc == null ? null : esc.getEscapeCodesForAscii());
        return this;
    }

    public CharacterEscapes getCharacterEscapes() {
        return this._characterEscapes;
    }

    protected boolean isEnabled(Feature f) {
        return (this._bsonFeatures & f.getMask()) != 0;
    }

    protected boolean isArray() {
        return this._currentDocument != null && this._currentDocument.currentArrayPos >= 0;
    }

    protected int getAndIncCurrentArrayPos() {
        if (this._currentDocument == null) {
            return -1;
        }
        int r = this._currentDocument.currentArrayPos++;
        return r;
    }

    protected void reserveHeader() {
        this._buffer.putInt(0);
    }

    protected void putHeader(int pos) {
        this._buffer.putInt(pos, this._buffer.size() - pos);
    }

    public void flush() throws IOException {
        if (this._currentDocument == null) {
            this._buffer.writeTo(this._out);
            this._buffer.clear();
        }
        this._out.flush();
    }

    protected void _releaseBuffers() {
        this._buffer.clear();
    }

    public void close() throws IOException {
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_JSON_CONTENT)) {
            while (this._currentDocument != null) {
                this.writeEndObject();
            }
        }
        this._buffer.writeTo(this._out);
        this._buffer.clear();
        this._out.flush();
        if (this.isEnabled(JsonGenerator.Feature.AUTO_CLOSE_TARGET)) {
            this._out.close();
        }
        super.close();
    }

    public void writeStartArray() throws IOException, JsonGenerationException {
        this._verifyValueWrite("start an array");
        this._writeContext = this._writeContext.createChildArrayContext();
        this._writeStartObject(true);
    }

    public void writeEndArray() throws IOException, JsonGenerationException {
        if (!this._writeContext.inArray()) {
            this._reportError("Current context not an ARRAY but " + this._writeContext.getTypeDesc());
        }
        this.writeEndObjectInternal();
        this._writeContext = this._writeContext.getParent();
    }

    public void writeStartObject() throws IOException, JsonGenerationException {
        if (this.nextObjectIsEmbeddedInValue) {
            this._writeContext = this._writeContext.createChildObjectContext();
            this._currentDocument = new DocumentInfo(this._currentDocument, this._buffer.size(), false);
            this.reserveHeader();
            this.nextObjectIsEmbeddedInValue = false;
        } else {
            this._verifyValueWrite("start an object");
            this._writeContext = this._writeContext.createChildObjectContext();
            this._writeStartObject(false);
        }
    }

    protected void _writeStartObject(boolean array) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        if (this._currentDocument != null) {
            this._buffer.putByte(this._typeMarker, array ? (byte)4 : 3);
        }
        this._currentDocument = new DocumentInfo(this._currentDocument, this._buffer.size(), array);
        this.reserveHeader();
    }

    public void writeEndObject() throws IOException, JsonGenerationException {
        if (!this._writeContext.inObject()) {
            this._reportError("Current context not an object but " + this._writeContext.getTypeDesc());
        }
        this._writeContext = this._writeContext.getParent();
        this.writeEndObjectInternal();
    }

    protected void writeEndObjectInternal() {
        if (this._currentDocument != null) {
            this._buffer.putByte((byte)0);
            DocumentInfo info = this._currentDocument;
            this._currentDocument = this._currentDocument.parent;
            if (!this.isEnabled(Feature.ENABLE_STREAMING)) {
                this.putHeader(info.headerPos);
            }
        }
    }

    protected void _writeArrayFieldNameIfNeeded() throws IOException {
        if (this.isArray()) {
            int p = this.getAndIncCurrentArrayPos();
            this._writeFieldName(String.valueOf(p));
        }
    }

    public void writeFieldName(String name) throws IOException, JsonGenerationException {
        int status = this._writeContext.writeFieldName(name);
        if (status == 4) {
            this._reportError("Can not write a field name, expecting a value");
        }
        this._writeFieldName(name);
    }

    protected void _writeFieldName(String name) throws IOException, JsonGenerationException {
        name = this.escapeCharacters(name);
        this._typeMarker = this._buffer.size();
        this._buffer.putByte((byte)0);
        this._buffer.putUTF8(name);
        this._buffer.putByte((byte)0);
    }

    protected void _verifyValueWrite(String typeMsg) throws IOException {
        int status = this._writeContext.writeValue();
        if (status == 5) {
            this._reportError("Can not " + typeMsg + ", expecting field name");
        }
    }

    protected void flushBuffer() throws IOException {
        if (this.isEnabled(Feature.ENABLE_STREAMING)) {
            this._buffer.flushTo(this._out);
        }
    }

    public void writeString(String text) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write string");
        this._buffer.putByte(this._typeMarker, (byte)2);
        this._writeString(text);
        this.flushBuffer();
    }

    public void writeString(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeString(new String(text, offset, len));
    }

    public void writeRaw(String text) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw string");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(text.length() * 2);
        this._buffer.putByte((byte)0);
        this._buffer.putString(text);
        this.flushBuffer();
    }

    public void writeRaw(String text, int offset, int len) throws IOException, JsonGenerationException {
        this.writeRaw(text.substring(offset, len));
    }

    public void writeRaw(char[] text, int offset, int len) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw string");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(text.length * 2);
        this._buffer.putByte((byte)0);
        this._buffer.putString(CharBuffer.wrap(text));
        this.flushBuffer();
    }

    public void writeRaw(char c) throws IOException, JsonGenerationException {
        this.writeRaw(new char[]{c}, 0, 1);
    }

    public void writeBinary(Base64Variant b64variant, byte[] data, int offset, int len) throws IOException, JsonGenerationException {
        this.writeBinary(b64variant, (byte)0, data, offset, len);
    }

    public void writeBinary(Base64Variant b64variant, byte subType, byte[] data, int offset, int len) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write binary");
        this._buffer.putByte(this._typeMarker, (byte)5);
        this._buffer.putInt(len);
        this._buffer.putByte(subType);
        int end = offset + len;
        if (end > data.length) {
            end = data.length;
        }
        while (offset < end) {
            this._buffer.putByte(data[offset]);
            ++offset;
        }
        this.flushBuffer();
    }

    public void writeNumber(int v) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)16);
        this._buffer.putInt(v);
        this.flushBuffer();
    }

    public void writeNumber(long v) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)18);
        this._buffer.putLong(v);
        this.flushBuffer();
    }

    public void writeNumber(BigInteger v) throws IOException, JsonGenerationException {
        int bl = v.bitLength();
        if (bl < 32) {
            this.writeNumber(v.intValue());
        } else if (bl < 64) {
            this.writeNumber(v.longValue());
        } else {
            this.writeString(v.toString());
        }
    }

    public void writeNumber(double d) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write number");
        this._buffer.putByte(this._typeMarker, (byte)1);
        this._buffer.putDouble(d);
        this.flushBuffer();
    }

    public void writeNumber(float f) throws IOException, JsonGenerationException {
        this.writeNumber((double)f);
    }

    public void writeNumber(BigDecimal dec) throws IOException, JsonGenerationException {
        if (this.isEnabled(Feature.WRITE_BIGDECIMALS_AS_DECIMAL128)) {
            Decimal128 d = new Decimal128(dec);
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write number");
            this._buffer.putByte(this._typeMarker, (byte)19);
            this._buffer.putLong(d.getLow());
            this._buffer.putLong(d.getHigh());
            this.flushBuffer();
            return;
        }
        if (this.isEnabled(Feature.WRITE_BIGDECIMALS_AS_STRINGS)) {
            this.writeString(dec.toString());
            return;
        }
        double d = dec.doubleValue();
        if (!Double.isInfinite(d)) {
            this.writeNumber(d);
        } else {
            this.writeString(dec.toString());
        }
    }

    public void writeNumber(String encodedValue) throws IOException, JsonGenerationException, UnsupportedOperationException {
        this.writeString(encodedValue);
    }

    public void writeBoolean(boolean state) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write boolean");
        this._buffer.putByte(this._typeMarker, (byte)8);
        this._buffer.putByte((byte)(state ? 1 : 0));
        this.flushBuffer();
    }

    public void writeNull() throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write null");
        this._buffer.putByte(this._typeMarker, (byte)10);
        this.flushBuffer();
    }

    public void writeRawUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write raw utf8 string");
        this._buffer.putByte(this._typeMarker, (byte)2);
        int p = this._buffer.size();
        this._buffer.putInt(0);
        for (int i = offset; i < length; ++i) {
            this._buffer.putByte(text[i]);
        }
        this._buffer.putByte((byte)0);
        this._buffer.putInt(p, length);
        this.flushBuffer();
    }

    public void writeUTF8String(byte[] text, int offset, int length) throws IOException, JsonGenerationException {
        this.writeRawUTF8String(text, offset, length);
    }

    public void writeDateTime(Date date) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write datetime");
        this._buffer.putByte(this._typeMarker, (byte)9);
        this._buffer.putLong(date.getTime());
        this.flushBuffer();
    }

    public void writeObjectId(ObjectId objectId) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write datetime");
        this._buffer.putByte(this._typeMarker, (byte)7);
        int time = ByteOrderUtil.flip(objectId.getTime());
        int machine = ByteOrderUtil.flip(objectId.getMachine());
        int inc = ByteOrderUtil.flip(objectId.getInc());
        this._buffer.putInt(time);
        this._buffer.putInt(machine);
        this._buffer.putInt(inc);
        this.flushBuffer();
    }

    protected String flagsToRegexOptions(int flags) {
        StringBuilder options = new StringBuilder();
        if ((flags & 2) != 0) {
            options.append("i");
        }
        if ((flags & 8) != 0) {
            options.append("m");
        }
        if ((flags & 0x20) != 0) {
            options.append("s");
        }
        if ((flags & 0x40) != 0) {
            options.append("u");
        }
        return options.toString();
    }

    public void writeRegex(Pattern pattern) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write regex");
        this._buffer.putByte(this._typeMarker, (byte)11);
        this._writeCString(pattern.pattern());
        this._writeCString(this.flagsToRegexOptions(pattern.flags()));
        this.flushBuffer();
    }

    public void writeTimestamp(Timestamp timestamp) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write timestamp");
        this._buffer.putByte(this._typeMarker, (byte)17);
        this._buffer.putInt(timestamp.getInc());
        this._buffer.putInt(timestamp.getTime());
        this.flushBuffer();
    }

    public void writeJavaScript(JavaScript javaScript, SerializerProvider provider) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write javascript");
        if (javaScript.getScope() == null) {
            this._buffer.putByte(this._typeMarker, (byte)13);
            this._writeString(javaScript.getCode());
        } else {
            this._buffer.putByte(this._typeMarker, (byte)15);
            int p = this._buffer.size();
            this._buffer.putInt(0);
            this._writeString(javaScript.getCode());
            this.nextObjectIsEmbeddedInValue = true;
            provider.findValueSerializer(Map.class, null).serialize(javaScript.getScope(), (JsonGenerator)this, provider);
            if (!this.isEnabled(Feature.ENABLE_STREAMING)) {
                int l = this._buffer.size() - p;
                this._buffer.putInt(p, l);
            }
        }
        this.flushBuffer();
    }

    public void writeSymbol(Symbol symbol) throws IOException {
        this._writeArrayFieldNameIfNeeded();
        this._verifyValueWrite("write symbol");
        this._buffer.putByte(this._typeMarker, (byte)14);
        this._writeString(symbol.getSymbol());
        this.flushBuffer();
    }

    protected int _writeString(String string) throws IOException {
        int p = this._buffer.size();
        this._buffer.putInt(0);
        int l = this._writeCString(string);
        this._buffer.putInt(p, l);
        return l + 4;
    }

    protected int _writeCString(String string) throws IOException {
        string = this.escapeCharacters(string);
        int l = this._buffer.putUTF8(string);
        this._buffer.putByte((byte)0);
        return l + 1;
    }

    protected String escapeCharacters(String string) throws IOException {
        if (this._characterEscapes == null) {
            return string;
        }
        StringBuilder sb = null;
        int lastEscapePos = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c > '\u007f' || this._outputEscapes[c] != -2) continue;
            SerializableString escape = this._characterEscapes.getEscapeSequence((int)c);
            if (escape == null) {
                this._reportError("Invalid custom escape definitions; custom escape not found for character code 0x" + Integer.toHexString(c) + ", although was supposed to have one");
            }
            if (sb == null) {
                sb = new StringBuilder();
            }
            if (i > lastEscapePos) {
                sb.append(string, lastEscapePos, i);
            }
            lastEscapePos = i + 1;
            sb.append(escape.getValue());
        }
        if (sb != null && lastEscapePos < string.length()) {
            sb.append(string, lastEscapePos, string.length());
        }
        if (sb == null) {
            return string;
        }
        return sb.toString();
    }

    protected static class DocumentInfo {
        final DocumentInfo parent;
        final int headerPos;
        int currentArrayPos;

        public DocumentInfo(DocumentInfo parent, int headerPos, boolean array) {
            this.parent = parent;
            this.headerPos = headerPos;
            this.currentArrayPos = array ? 0 : -1;
        }
    }

    public static enum Feature {
        ENABLE_STREAMING,
        WRITE_BIGDECIMALS_AS_STRINGS,
        WRITE_BIGDECIMALS_AS_DECIMAL128;


        public int getMask() {
            return 1 << this.ordinal();
        }
    }
}

