/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.io.swing;

import de.schlichtherle.io.ArchiveDetector;
import de.schlichtherle.io.swing.FileSystemView;
import de.schlichtherle.io.swing.FileView;
import java.awt.Graphics;
import java.io.File;
import javax.swing.Icon;

public class JFileChooser
extends javax.swing.JFileChooser {
    private volatile transient short paintingDisabled;

    public JFileChooser() {
        super(FileSystemView.getFileSystemView());
        super.setFileView(new FileView(super.getFileView()));
        super.setDoubleBuffered(false);
    }

    public JFileChooser(ArchiveDetector archiveDetector) {
        super(FileSystemView.getFileSystemView(archiveDetector));
        super.setFileView(new FileView(super.getFileView()));
        super.setDoubleBuffered(false);
    }

    public File getSelectedFile() {
        File file = super.getSelectedFile();
        return ((FileSystemView)this.getFileSystemView()).wrap(file);
    }

    public File[] getSelectedFiles() {
        File[] files = super.getSelectedFiles();
        if (files != null) {
            FileSystemView fsv = (FileSystemView)this.getFileSystemView();
            int i = files.length;
            while (--i >= 0) {
                files[i] = fsv.wrap(files[i]);
            }
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Icon getIcon(File file) {
        this.beginPaintingDisabled();
        try {
            Icon icon = super.getIcon(file);
            return icon;
        }
        finally {
            this.endPaintingDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTypeDescription(File file) {
        this.beginPaintingDisabled();
        try {
            String string = super.getTypeDescription(file);
            return string;
        }
        finally {
            this.endPaintingDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTraversable(File file) {
        this.beginPaintingDisabled();
        try {
            boolean bl = super.isTraversable(file);
            return bl;
        }
        finally {
            this.endPaintingDisabled();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        if (this.paintingDisabled <= 0) {
            this.beginPaintingDisabled();
            try {
                super.paintChildren(g);
            }
            finally {
                this.endPaintingDisabled();
            }
        }
    }

    private synchronized void beginPaintingDisabled() {
        this.paintingDisabled = (short)(this.paintingDisabled + 1);
    }

    private synchronized void endPaintingDisabled() {
        this.paintingDisabled = (short)(this.paintingDisabled - 1);
        if (this.paintingDisabled <= 0) {
            this.repaint();
        }
    }
}

