/*
 * Decompiled with CFR 0.152.
 */
package de.pdark.decentxml;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class JoinedInputStream
extends InputStream {
    private List<InputStream> streams = new ArrayList<InputStream>();

    public JoinedInputStream add(InputStream in) {
        this.streams.add(in);
        return this;
    }

    public int read() throws IOException {
        while (!this.streams.isEmpty()) {
            int result = this.streams.get(0).read();
            if (result != -1) {
                return result;
            }
            this.popStream();
        }
        return -1;
    }

    private void popStream() throws IOException {
        this.streams.remove(0).close();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        while (!this.streams.isEmpty()) {
            int result = this.streams.get(0).read(b, off, len);
            if (result != -1) {
                return result;
            }
            this.popStream();
        }
        return -1;
    }

    public void close() throws IOException {
        while (!this.streams.isEmpty()) {
            this.popStream();
        }
        this.streams = null;
    }
}

