/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.types;

import de.flapdoodle.embed.mongo.types.SystemProperties;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ImmutableSystemProperties
extends SystemProperties {
    private final Map<String, String> value;

    private ImmutableSystemProperties(Map<String, String> value) {
        this.value = value;
    }

    @Override
    public Map<String, String> value() {
        return this.value;
    }

    public final ImmutableSystemProperties withValue(Map<String, ? extends String> entries) {
        if (this.value == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableSystemProperties.createUnmodifiableMap(true, false, entries);
        return new ImmutableSystemProperties(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSystemProperties && this.equalTo(0, (ImmutableSystemProperties)another);
    }

    private boolean equalTo(int synthetic, ImmutableSystemProperties another) {
        return this.value.equals(another.value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        return h;
    }

    public String toString() {
        return "SystemProperties{value=" + this.value + "}";
    }

    public static ImmutableSystemProperties copyOf(SystemProperties instance) {
        if (instance instanceof ImmutableSystemProperties) {
            return (ImmutableSystemProperties)instance;
        }
        return ImmutableSystemProperties.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size() * 4 / 3 + 1);
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, v == null ? "value for key: " + k : null);
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    public static final class Builder {
        private Map<String, String> value = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(SystemProperties instance) {
            Objects.requireNonNull(instance, "instance");
            this.putAllValue(instance.value());
            return this;
        }

        public final Builder putValue(String key, String value) {
            this.value.put(Objects.requireNonNull(key, "value key"), Objects.requireNonNull(value, value == null ? "value value for key: " + key : null));
            return this;
        }

        public final Builder putValue(Map.Entry<String, ? extends String> entry) {
            String k = entry.getKey();
            String v = entry.getValue();
            this.value.put(Objects.requireNonNull(k, "value key"), Objects.requireNonNull(v, v == null ? "value value for key: " + k : null));
            return this;
        }

        public final Builder value(Map<String, ? extends String> entries) {
            this.value.clear();
            return this.putAllValue(entries);
        }

        public final Builder putAllValue(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String k = e.getKey();
                String v = e.getValue();
                this.value.put(Objects.requireNonNull(k, "value key"), Objects.requireNonNull(v, v == null ? "value value for key: " + k : null));
            }
            return this;
        }

        public ImmutableSystemProperties build() {
            return new ImmutableSystemProperties(ImmutableSystemProperties.createUnmodifiableMap(false, false, this.value));
        }
    }
}

