/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.transitions;

import de.flapdoodle.embed.mongo.config.Net;
import de.flapdoodle.embed.mongo.types.StartTimeout;
import de.flapdoodle.embed.process.archives.ExtractedFileSet;
import de.flapdoodle.embed.process.config.SupportConfig;
import de.flapdoodle.embed.process.io.ProcessOutput;
import de.flapdoodle.embed.process.types.ProcessArguments;
import de.flapdoodle.embed.process.types.ProcessConfig;
import de.flapdoodle.embed.process.types.ProcessEnv;
import de.flapdoodle.embed.process.types.ProcessWorkingDir;
import de.flapdoodle.embed.process.types.RunningProcess;
import de.flapdoodle.embed.process.types.RunningProcessFactory;
import de.flapdoodle.os.Platform;
import de.flapdoodle.reverse.State;
import de.flapdoodle.reverse.StateID;
import de.flapdoodle.reverse.StateLookup;
import de.flapdoodle.reverse.TearDown;
import de.flapdoodle.reverse.Transition;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.immutables.value.Value;

public abstract class MongoServerStarter<T extends RunningProcess>
implements Transition<T> {
    @Value.Default
    public StateID<ExtractedFileSet> processExecutable() {
        return StateID.of(ExtractedFileSet.class);
    }

    public StateID<ProcessWorkingDir> processWorkingDir() {
        return StateID.of(ProcessWorkingDir.class);
    }

    @Value.Default
    public StateID<ProcessConfig> processConfig() {
        return StateID.of(ProcessConfig.class);
    }

    @Value.Default
    public StateID<ProcessEnv> processEnv() {
        return StateID.of(ProcessEnv.class);
    }

    @Value.Default
    public StateID<ProcessArguments> arguments() {
        return StateID.of(ProcessArguments.class);
    }

    @Value.Default
    public StateID<ProcessOutput> processOutput() {
        return StateID.of(ProcessOutput.class);
    }

    @Value.Default
    public StateID<SupportConfig> supportConfig() {
        return StateID.of(SupportConfig.class);
    }

    @Value.Default
    public StateID<Platform> platform() {
        return StateID.of(Platform.class);
    }

    @Value.Default
    public StateID<Net> net() {
        return StateID.of(Net.class);
    }

    @Value.Default
    public StateID<StartTimeout> startTimeout() {
        return StateID.of(StartTimeout.class);
    }

    public Set<StateID<?>> sources() {
        return StateID.setOf((StateID[])new StateID[]{this.processWorkingDir(), this.processExecutable(), this.processConfig(), this.processEnv(), this.startTimeout(), this.arguments(), this.processOutput(), this.supportConfig(), this.platform(), this.net()});
    }

    @Value.Auxiliary
    protected abstract RunningProcessFactory<T> factory(long var1, SupportConfig var3, Platform var4, Net var5);

    public State<T> result(StateLookup lookup) {
        Path processWorkingDir = ((ProcessWorkingDir)lookup.of(this.processWorkingDir())).value();
        ExtractedFileSet fileSet = (ExtractedFileSet)lookup.of(this.processExecutable());
        List arguments = ((ProcessArguments)lookup.of(this.arguments())).value();
        Map environment = ((ProcessEnv)lookup.of(this.processEnv())).value();
        ProcessConfig processConfig = (ProcessConfig)lookup.of(this.processConfig());
        StartTimeout startTimeout = (StartTimeout)((Object)lookup.of(this.startTimeout()));
        ProcessOutput processOutput = (ProcessOutput)lookup.of(this.processOutput());
        SupportConfig supportConfig = (SupportConfig)lookup.of(this.supportConfig());
        Platform platform = (Platform)lookup.of(this.platform());
        Net net = (Net)lookup.of(this.net());
        try {
            RunningProcessFactory<T> factory = this.factory(startTimeout.value(), supportConfig, platform, net);
            RunningProcess running = RunningProcess.start(factory, (Path)processWorkingDir, (Path)fileSet.executable(), (List)arguments, (Map)environment, (ProcessConfig)processConfig, (ProcessOutput)processOutput, (SupportConfig)supportConfig);
            return State.of((Object)running, (TearDown[])new TearDown[]{RunningProcess::stop});
        }
        catch (IOException ix) {
            String hint = "";
            if (ix.getMessage().contains("Bad CPU type in executable")) {
                hint = " - " + platform.toString();
            }
            throw new RuntimeException("could not start process" + hint, ix);
        }
    }
}

