/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.MongoShellArguments;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class ImmutableMongoShellArguments
extends MongoShellArguments {
    private final List<String> scriptParameters;
    private final String scriptName;
    private final String dbName;
    private final String password;
    private final String userName;

    private ImmutableMongoShellArguments(List<String> scriptParameters, String scriptName, String dbName, String password, String userName) {
        this.scriptParameters = scriptParameters;
        this.scriptName = scriptName;
        this.dbName = dbName;
        this.password = password;
        this.userName = userName;
    }

    @Override
    public List<String> scriptParameters() {
        return this.scriptParameters;
    }

    @Override
    public Optional<String> scriptName() {
        return Optional.ofNullable(this.scriptName);
    }

    @Override
    public Optional<String> dbName() {
        return Optional.ofNullable(this.dbName);
    }

    @Override
    public Optional<String> password() {
        return Optional.ofNullable(this.password);
    }

    @Override
    public Optional<String> userName() {
        return Optional.ofNullable(this.userName);
    }

    public final ImmutableMongoShellArguments withScriptParameters(String ... elements) {
        List<String> newValue = ImmutableMongoShellArguments.createUnmodifiableList(false, ImmutableMongoShellArguments.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMongoShellArguments(newValue, this.scriptName, this.dbName, this.password, this.userName);
    }

    public final ImmutableMongoShellArguments withScriptParameters(Iterable<String> elements) {
        if (this.scriptParameters == elements) {
            return this;
        }
        List<String> newValue = ImmutableMongoShellArguments.createUnmodifiableList(false, ImmutableMongoShellArguments.createSafeList(elements, true, false));
        return new ImmutableMongoShellArguments(newValue, this.scriptName, this.dbName, this.password, this.userName);
    }

    public final ImmutableMongoShellArguments withScriptName(String value) {
        String newValue = Objects.requireNonNull(value, "scriptName");
        if (Objects.equals(this.scriptName, newValue)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, newValue, this.dbName, this.password, this.userName);
    }

    public final ImmutableMongoShellArguments withScriptName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.scriptName, value)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, value, this.dbName, this.password, this.userName);
    }

    public final ImmutableMongoShellArguments withDbName(String value) {
        String newValue = Objects.requireNonNull(value, "dbName");
        if (Objects.equals(this.dbName, newValue)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, this.scriptName, newValue, this.password, this.userName);
    }

    public final ImmutableMongoShellArguments withDbName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dbName, value)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, this.scriptName, value, this.password, this.userName);
    }

    public final ImmutableMongoShellArguments withPassword(String value) {
        String newValue = Objects.requireNonNull(value, "password");
        if (Objects.equals(this.password, newValue)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, this.scriptName, this.dbName, newValue, this.userName);
    }

    public final ImmutableMongoShellArguments withPassword(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.password, value)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, this.scriptName, this.dbName, value, this.userName);
    }

    public final ImmutableMongoShellArguments withUserName(String value) {
        String newValue = Objects.requireNonNull(value, "userName");
        if (Objects.equals(this.userName, newValue)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, this.scriptName, this.dbName, this.password, newValue);
    }

    public final ImmutableMongoShellArguments withUserName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.userName, value)) {
            return this;
        }
        return new ImmutableMongoShellArguments(this.scriptParameters, this.scriptName, this.dbName, this.password, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoShellArguments && this.equalTo(0, (ImmutableMongoShellArguments)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoShellArguments another) {
        return this.scriptParameters.equals(another.scriptParameters) && Objects.equals(this.scriptName, another.scriptName) && Objects.equals(this.dbName, another.dbName) && Objects.equals(this.password, another.password) && Objects.equals(this.userName, another.userName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.scriptParameters.hashCode();
        h += (h << 5) + Objects.hashCode(this.scriptName);
        h += (h << 5) + Objects.hashCode(this.dbName);
        h += (h << 5) + Objects.hashCode(this.password);
        h += (h << 5) + Objects.hashCode(this.userName);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongoShellArguments{");
        builder.append("scriptParameters=").append(this.scriptParameters);
        if (this.scriptName != null) {
            builder.append(", ");
            builder.append("scriptName=").append(this.scriptName);
        }
        if (this.dbName != null) {
            builder.append(", ");
            builder.append("dbName=").append(this.dbName);
        }
        if (this.password != null) {
            builder.append(", ");
            builder.append("password=").append(this.password);
        }
        if (this.userName != null) {
            builder.append(", ");
            builder.append("userName=").append(this.userName);
        }
        return builder.append("}").toString();
    }

    public static ImmutableMongoShellArguments copyOf(MongoShellArguments instance) {
        if (instance instanceof ImmutableMongoShellArguments) {
            return (ImmutableMongoShellArguments)instance;
        }
        return ImmutableMongoShellArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private List<String> scriptParameters = new ArrayList<String>();
        private String scriptName;
        private String dbName;
        private String password;
        private String userName;

        private Builder() {
        }

        public final Builder from(MongoShellArguments instance) {
            Optional<String> userNameOptional;
            Optional<String> passwordOptional;
            Optional<String> dbNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllScriptParameters(instance.scriptParameters());
            Optional<String> scriptNameOptional = instance.scriptName();
            if (scriptNameOptional.isPresent()) {
                this.scriptName(scriptNameOptional);
            }
            if ((dbNameOptional = instance.dbName()).isPresent()) {
                this.dbName(dbNameOptional);
            }
            if ((passwordOptional = instance.password()).isPresent()) {
                this.password(passwordOptional);
            }
            if ((userNameOptional = instance.userName()).isPresent()) {
                this.userName(userNameOptional);
            }
            return this;
        }

        public final Builder addScriptParameters(String element) {
            this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
            return this;
        }

        public final Builder addScriptParameters(String ... elements) {
            for (String element : elements) {
                this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
            }
            return this;
        }

        public final Builder scriptParameters(Iterable<String> elements) {
            this.scriptParameters.clear();
            return this.addAllScriptParameters(elements);
        }

        public final Builder addAllScriptParameters(Iterable<String> elements) {
            for (String element : elements) {
                this.scriptParameters.add(Objects.requireNonNull(element, "scriptParameters element"));
            }
            return this;
        }

        public final Builder scriptName(String scriptName) {
            this.scriptName = Objects.requireNonNull(scriptName, "scriptName");
            return this;
        }

        public final Builder scriptName(Optional<String> scriptName) {
            this.scriptName = scriptName.orElse(null);
            return this;
        }

        public final Builder dbName(String dbName) {
            this.dbName = Objects.requireNonNull(dbName, "dbName");
            return this;
        }

        public final Builder dbName(Optional<String> dbName) {
            this.dbName = dbName.orElse(null);
            return this;
        }

        public final Builder password(String password) {
            this.password = Objects.requireNonNull(password, "password");
            return this;
        }

        public final Builder password(Optional<String> password) {
            this.password = password.orElse(null);
            return this;
        }

        public final Builder userName(String userName) {
            this.userName = Objects.requireNonNull(userName, "userName");
            return this;
        }

        public final Builder userName(Optional<String> userName) {
            this.userName = userName.orElse(null);
            return this;
        }

        public ImmutableMongoShellArguments build() {
            return new ImmutableMongoShellArguments(ImmutableMongoShellArguments.createUnmodifiableList(true, this.scriptParameters), this.scriptName, this.dbName, this.password, this.userName);
        }
    }
}

