/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.commands;

import de.flapdoodle.embed.mongo.commands.MongoRestoreArguments;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

public final class ImmutableMongoRestoreArguments
extends MongoRestoreArguments {
    private final boolean verbose;
    private final String databaseName;
    private final String collectionName;
    private final Long oplogLimit;
    private final String archive;
    private final String dir;
    private final Integer numberOfParallelCollections;
    private final Integer numberOfInsertionWorkersPerCollection;
    private final String writeConcern;
    private final boolean objectCheck;
    private final boolean oplogReplay;
    private final boolean restoreDbUsersAndRoles;
    private final boolean gzip;
    private final boolean dropCollection;
    private final boolean noIndexRestore;
    private final boolean noOptionsRestore;
    private final boolean keepIndexVersion;
    private final boolean maintainInsertionOrder;
    private final boolean stopOnError;
    private final boolean bypassDocumentValidation;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMongoRestoreArguments(Builder builder) {
        this.databaseName = builder.databaseName;
        this.collectionName = builder.collectionName;
        this.oplogLimit = builder.oplogLimit;
        this.archive = builder.archive;
        this.dir = builder.dir;
        this.numberOfParallelCollections = builder.numberOfParallelCollections;
        this.numberOfInsertionWorkersPerCollection = builder.numberOfInsertionWorkersPerCollection;
        this.writeConcern = builder.writeConcern;
        if (builder.verboseIsSet()) {
            this.initShim.verbose(builder.verbose);
        }
        if (builder.objectCheckIsSet()) {
            this.initShim.objectCheck(builder.objectCheck);
        }
        if (builder.oplogReplayIsSet()) {
            this.initShim.oplogReplay(builder.oplogReplay);
        }
        if (builder.restoreDbUsersAndRolesIsSet()) {
            this.initShim.restoreDbUsersAndRoles(builder.restoreDbUsersAndRoles);
        }
        if (builder.gzipIsSet()) {
            this.initShim.gzip(builder.gzip);
        }
        if (builder.dropCollectionIsSet()) {
            this.initShim.dropCollection(builder.dropCollection);
        }
        if (builder.noIndexRestoreIsSet()) {
            this.initShim.noIndexRestore(builder.noIndexRestore);
        }
        if (builder.noOptionsRestoreIsSet()) {
            this.initShim.noOptionsRestore(builder.noOptionsRestore);
        }
        if (builder.keepIndexVersionIsSet()) {
            this.initShim.keepIndexVersion(builder.keepIndexVersion);
        }
        if (builder.maintainInsertionOrderIsSet()) {
            this.initShim.maintainInsertionOrder(builder.maintainInsertionOrder);
        }
        if (builder.stopOnErrorIsSet()) {
            this.initShim.stopOnError(builder.stopOnError);
        }
        if (builder.bypassDocumentValidationIsSet()) {
            this.initShim.bypassDocumentValidation(builder.bypassDocumentValidation);
        }
        this.verbose = this.initShim.verbose();
        this.objectCheck = this.initShim.objectCheck();
        this.oplogReplay = this.initShim.oplogReplay();
        this.restoreDbUsersAndRoles = this.initShim.restoreDbUsersAndRoles();
        this.gzip = this.initShim.gzip();
        this.dropCollection = this.initShim.dropCollection();
        this.noIndexRestore = this.initShim.noIndexRestore();
        this.noOptionsRestore = this.initShim.noOptionsRestore();
        this.keepIndexVersion = this.initShim.keepIndexVersion();
        this.maintainInsertionOrder = this.initShim.maintainInsertionOrder();
        this.stopOnError = this.initShim.stopOnError();
        this.bypassDocumentValidation = this.initShim.bypassDocumentValidation();
        this.initShim = null;
    }

    private ImmutableMongoRestoreArguments(boolean verbose, String databaseName, String collectionName, Long oplogLimit, String archive, String dir, Integer numberOfParallelCollections, Integer numberOfInsertionWorkersPerCollection, String writeConcern, boolean objectCheck, boolean oplogReplay, boolean restoreDbUsersAndRoles, boolean gzip, boolean dropCollection, boolean noIndexRestore, boolean noOptionsRestore, boolean keepIndexVersion, boolean maintainInsertionOrder, boolean stopOnError, boolean bypassDocumentValidation) {
        this.verbose = verbose;
        this.databaseName = databaseName;
        this.collectionName = collectionName;
        this.oplogLimit = oplogLimit;
        this.archive = archive;
        this.dir = dir;
        this.numberOfParallelCollections = numberOfParallelCollections;
        this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection;
        this.writeConcern = writeConcern;
        this.objectCheck = objectCheck;
        this.oplogReplay = oplogReplay;
        this.restoreDbUsersAndRoles = restoreDbUsersAndRoles;
        this.gzip = gzip;
        this.dropCollection = dropCollection;
        this.noIndexRestore = noIndexRestore;
        this.noOptionsRestore = noOptionsRestore;
        this.keepIndexVersion = keepIndexVersion;
        this.maintainInsertionOrder = maintainInsertionOrder;
        this.stopOnError = stopOnError;
        this.bypassDocumentValidation = bypassDocumentValidation;
        this.initShim = null;
    }

    @Override
    public boolean verbose() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verbose() : this.verbose;
    }

    @Override
    public Optional<String> databaseName() {
        return Optional.ofNullable(this.databaseName);
    }

    @Override
    public Optional<String> collectionName() {
        return Optional.ofNullable(this.collectionName);
    }

    @Override
    public OptionalLong oplogLimit() {
        return this.oplogLimit != null ? OptionalLong.of(this.oplogLimit) : OptionalLong.empty();
    }

    @Override
    public Optional<String> archive() {
        return Optional.ofNullable(this.archive);
    }

    @Override
    public Optional<String> dir() {
        return Optional.ofNullable(this.dir);
    }

    @Override
    public OptionalInt numberOfParallelCollections() {
        return this.numberOfParallelCollections != null ? OptionalInt.of(this.numberOfParallelCollections) : OptionalInt.empty();
    }

    @Override
    public OptionalInt numberOfInsertionWorkersPerCollection() {
        return this.numberOfInsertionWorkersPerCollection != null ? OptionalInt.of(this.numberOfInsertionWorkersPerCollection) : OptionalInt.empty();
    }

    @Override
    public Optional<String> writeConcern() {
        return Optional.ofNullable(this.writeConcern);
    }

    @Override
    public boolean objectCheck() {
        InitShim shim = this.initShim;
        return shim != null ? shim.objectCheck() : this.objectCheck;
    }

    @Override
    public boolean oplogReplay() {
        InitShim shim = this.initShim;
        return shim != null ? shim.oplogReplay() : this.oplogReplay;
    }

    @Override
    public boolean restoreDbUsersAndRoles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.restoreDbUsersAndRoles() : this.restoreDbUsersAndRoles;
    }

    @Override
    public boolean gzip() {
        InitShim shim = this.initShim;
        return shim != null ? shim.gzip() : this.gzip;
    }

    @Override
    public boolean dropCollection() {
        InitShim shim = this.initShim;
        return shim != null ? shim.dropCollection() : this.dropCollection;
    }

    @Override
    public boolean noIndexRestore() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noIndexRestore() : this.noIndexRestore;
    }

    @Override
    public boolean noOptionsRestore() {
        InitShim shim = this.initShim;
        return shim != null ? shim.noOptionsRestore() : this.noOptionsRestore;
    }

    @Override
    public boolean keepIndexVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.keepIndexVersion() : this.keepIndexVersion;
    }

    @Override
    public boolean maintainInsertionOrder() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maintainInsertionOrder() : this.maintainInsertionOrder;
    }

    @Override
    public boolean stopOnError() {
        InitShim shim = this.initShim;
        return shim != null ? shim.stopOnError() : this.stopOnError;
    }

    @Override
    public boolean bypassDocumentValidation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.bypassDocumentValidation() : this.bypassDocumentValidation;
    }

    public final ImmutableMongoRestoreArguments withVerbose(boolean value) {
        if (this.verbose == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(value, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withDatabaseName(String value) {
        String newValue = Objects.requireNonNull(value, "databaseName");
        if (Objects.equals(this.databaseName, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, newValue, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withDatabaseName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.databaseName, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, value, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withCollectionName(String value) {
        String newValue = Objects.requireNonNull(value, "collectionName");
        if (Objects.equals(this.collectionName, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, newValue, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withCollectionName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.collectionName, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, value, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withOplogLimit(long value) {
        Long newValue = value;
        if (Objects.equals(this.oplogLimit, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, newValue, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withOplogLimit(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.oplogLimit, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, value, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withArchive(String value) {
        String newValue = Objects.requireNonNull(value, "archive");
        if (Objects.equals(this.archive, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, newValue, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withArchive(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.archive, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, value, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withDir(String value) {
        String newValue = Objects.requireNonNull(value, "dir");
        if (Objects.equals(this.dir, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, newValue, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withDir(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.dir, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, value, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withNumberOfParallelCollections(int value) {
        Integer newValue = value;
        if (Objects.equals(this.numberOfParallelCollections, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, newValue, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withNumberOfParallelCollections(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.numberOfParallelCollections, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, value, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withNumberOfInsertionWorkersPerCollection(int value) {
        Integer newValue = value;
        if (Objects.equals(this.numberOfInsertionWorkersPerCollection, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, newValue, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withNumberOfInsertionWorkersPerCollection(OptionalInt optional) {
        Integer value;
        Integer n = value = optional.isPresent() ? Integer.valueOf(optional.getAsInt()) : null;
        if (Objects.equals(this.numberOfInsertionWorkersPerCollection, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, value, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withWriteConcern(String value) {
        String newValue = Objects.requireNonNull(value, "writeConcern");
        if (Objects.equals(this.writeConcern, newValue)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, newValue, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withWriteConcern(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.writeConcern, value)) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, value, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withObjectCheck(boolean value) {
        if (this.objectCheck == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, value, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withOplogReplay(boolean value) {
        if (this.oplogReplay == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, value, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withRestoreDbUsersAndRoles(boolean value) {
        if (this.restoreDbUsersAndRoles == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, value, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withGzip(boolean value) {
        if (this.gzip == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, value, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withDropCollection(boolean value) {
        if (this.dropCollection == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, value, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withNoIndexRestore(boolean value) {
        if (this.noIndexRestore == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, value, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withNoOptionsRestore(boolean value) {
        if (this.noOptionsRestore == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, value, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withKeepIndexVersion(boolean value) {
        if (this.keepIndexVersion == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, value, this.maintainInsertionOrder, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withMaintainInsertionOrder(boolean value) {
        if (this.maintainInsertionOrder == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, value, this.stopOnError, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withStopOnError(boolean value) {
        if (this.stopOnError == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, value, this.bypassDocumentValidation);
    }

    public final ImmutableMongoRestoreArguments withBypassDocumentValidation(boolean value) {
        if (this.bypassDocumentValidation == value) {
            return this;
        }
        return new ImmutableMongoRestoreArguments(this.verbose, this.databaseName, this.collectionName, this.oplogLimit, this.archive, this.dir, this.numberOfParallelCollections, this.numberOfInsertionWorkersPerCollection, this.writeConcern, this.objectCheck, this.oplogReplay, this.restoreDbUsersAndRoles, this.gzip, this.dropCollection, this.noIndexRestore, this.noOptionsRestore, this.keepIndexVersion, this.maintainInsertionOrder, this.stopOnError, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMongoRestoreArguments && this.equalTo(0, (ImmutableMongoRestoreArguments)another);
    }

    private boolean equalTo(int synthetic, ImmutableMongoRestoreArguments another) {
        return this.verbose == another.verbose && Objects.equals(this.databaseName, another.databaseName) && Objects.equals(this.collectionName, another.collectionName) && Objects.equals(this.oplogLimit, another.oplogLimit) && Objects.equals(this.archive, another.archive) && Objects.equals(this.dir, another.dir) && Objects.equals(this.numberOfParallelCollections, another.numberOfParallelCollections) && Objects.equals(this.numberOfInsertionWorkersPerCollection, another.numberOfInsertionWorkersPerCollection) && Objects.equals(this.writeConcern, another.writeConcern) && this.objectCheck == another.objectCheck && this.oplogReplay == another.oplogReplay && this.restoreDbUsersAndRoles == another.restoreDbUsersAndRoles && this.gzip == another.gzip && this.dropCollection == another.dropCollection && this.noIndexRestore == another.noIndexRestore && this.noOptionsRestore == another.noOptionsRestore && this.keepIndexVersion == another.keepIndexVersion && this.maintainInsertionOrder == another.maintainInsertionOrder && this.stopOnError == another.stopOnError && this.bypassDocumentValidation == another.bypassDocumentValidation;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.verbose);
        h += (h << 5) + Objects.hashCode(this.databaseName);
        h += (h << 5) + Objects.hashCode(this.collectionName);
        h += (h << 5) + Objects.hashCode(this.oplogLimit);
        h += (h << 5) + Objects.hashCode(this.archive);
        h += (h << 5) + Objects.hashCode(this.dir);
        h += (h << 5) + Objects.hashCode(this.numberOfParallelCollections);
        h += (h << 5) + Objects.hashCode(this.numberOfInsertionWorkersPerCollection);
        h += (h << 5) + Objects.hashCode(this.writeConcern);
        h += (h << 5) + Boolean.hashCode(this.objectCheck);
        h += (h << 5) + Boolean.hashCode(this.oplogReplay);
        h += (h << 5) + Boolean.hashCode(this.restoreDbUsersAndRoles);
        h += (h << 5) + Boolean.hashCode(this.gzip);
        h += (h << 5) + Boolean.hashCode(this.dropCollection);
        h += (h << 5) + Boolean.hashCode(this.noIndexRestore);
        h += (h << 5) + Boolean.hashCode(this.noOptionsRestore);
        h += (h << 5) + Boolean.hashCode(this.keepIndexVersion);
        h += (h << 5) + Boolean.hashCode(this.maintainInsertionOrder);
        h += (h << 5) + Boolean.hashCode(this.stopOnError);
        h += (h << 5) + Boolean.hashCode(this.bypassDocumentValidation);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MongoRestoreArguments{");
        builder.append("verbose=").append(this.verbose);
        if (this.databaseName != null) {
            builder.append(", ");
            builder.append("databaseName=").append(this.databaseName);
        }
        if (this.collectionName != null) {
            builder.append(", ");
            builder.append("collectionName=").append(this.collectionName);
        }
        if (this.oplogLimit != null) {
            builder.append(", ");
            builder.append("oplogLimit=").append(this.oplogLimit);
        }
        if (this.archive != null) {
            builder.append(", ");
            builder.append("archive=").append(this.archive);
        }
        if (this.dir != null) {
            builder.append(", ");
            builder.append("dir=").append(this.dir);
        }
        if (this.numberOfParallelCollections != null) {
            builder.append(", ");
            builder.append("numberOfParallelCollections=").append(this.numberOfParallelCollections);
        }
        if (this.numberOfInsertionWorkersPerCollection != null) {
            builder.append(", ");
            builder.append("numberOfInsertionWorkersPerCollection=").append(this.numberOfInsertionWorkersPerCollection);
        }
        if (this.writeConcern != null) {
            builder.append(", ");
            builder.append("writeConcern=").append(this.writeConcern);
        }
        builder.append(", ");
        builder.append("objectCheck=").append(this.objectCheck);
        builder.append(", ");
        builder.append("oplogReplay=").append(this.oplogReplay);
        builder.append(", ");
        builder.append("restoreDbUsersAndRoles=").append(this.restoreDbUsersAndRoles);
        builder.append(", ");
        builder.append("gzip=").append(this.gzip);
        builder.append(", ");
        builder.append("dropCollection=").append(this.dropCollection);
        builder.append(", ");
        builder.append("noIndexRestore=").append(this.noIndexRestore);
        builder.append(", ");
        builder.append("noOptionsRestore=").append(this.noOptionsRestore);
        builder.append(", ");
        builder.append("keepIndexVersion=").append(this.keepIndexVersion);
        builder.append(", ");
        builder.append("maintainInsertionOrder=").append(this.maintainInsertionOrder);
        builder.append(", ");
        builder.append("stopOnError=").append(this.stopOnError);
        builder.append(", ");
        builder.append("bypassDocumentValidation=").append(this.bypassDocumentValidation);
        return builder.append("}").toString();
    }

    public static ImmutableMongoRestoreArguments copyOf(MongoRestoreArguments instance) {
        if (instance instanceof ImmutableMongoRestoreArguments) {
            return (ImmutableMongoRestoreArguments)instance;
        }
        return ImmutableMongoRestoreArguments.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_VERBOSE = 1L;
        private static final long OPT_BIT_OBJECT_CHECK = 2L;
        private static final long OPT_BIT_OPLOG_REPLAY = 4L;
        private static final long OPT_BIT_RESTORE_DB_USERS_AND_ROLES = 8L;
        private static final long OPT_BIT_GZIP = 16L;
        private static final long OPT_BIT_DROP_COLLECTION = 32L;
        private static final long OPT_BIT_NO_INDEX_RESTORE = 64L;
        private static final long OPT_BIT_NO_OPTIONS_RESTORE = 128L;
        private static final long OPT_BIT_KEEP_INDEX_VERSION = 256L;
        private static final long OPT_BIT_MAINTAIN_INSERTION_ORDER = 512L;
        private static final long OPT_BIT_STOP_ON_ERROR = 1024L;
        private static final long OPT_BIT_BYPASS_DOCUMENT_VALIDATION = 2048L;
        private long optBits;
        private boolean verbose;
        private String databaseName;
        private String collectionName;
        private Long oplogLimit;
        private String archive;
        private String dir;
        private Integer numberOfParallelCollections;
        private Integer numberOfInsertionWorkersPerCollection;
        private String writeConcern;
        private boolean objectCheck;
        private boolean oplogReplay;
        private boolean restoreDbUsersAndRoles;
        private boolean gzip;
        private boolean dropCollection;
        private boolean noIndexRestore;
        private boolean noOptionsRestore;
        private boolean keepIndexVersion;
        private boolean maintainInsertionOrder;
        private boolean stopOnError;
        private boolean bypassDocumentValidation;

        private Builder() {
        }

        public final Builder from(MongoRestoreArguments instance) {
            Optional<String> writeConcernOptional;
            OptionalInt numberOfInsertionWorkersPerCollectionOptional;
            OptionalInt numberOfParallelCollectionsOptional;
            Optional<String> dirOptional;
            Optional<String> archiveOptional;
            OptionalLong oplogLimitOptional;
            Optional<String> collectionNameOptional;
            Objects.requireNonNull(instance, "instance");
            this.verbose(instance.verbose());
            Optional<String> databaseNameOptional = instance.databaseName();
            if (databaseNameOptional.isPresent()) {
                this.databaseName(databaseNameOptional);
            }
            if ((collectionNameOptional = instance.collectionName()).isPresent()) {
                this.collectionName(collectionNameOptional);
            }
            if ((oplogLimitOptional = instance.oplogLimit()).isPresent()) {
                this.oplogLimit(oplogLimitOptional);
            }
            if ((archiveOptional = instance.archive()).isPresent()) {
                this.archive(archiveOptional);
            }
            if ((dirOptional = instance.dir()).isPresent()) {
                this.dir(dirOptional);
            }
            if ((numberOfParallelCollectionsOptional = instance.numberOfParallelCollections()).isPresent()) {
                this.numberOfParallelCollections(numberOfParallelCollectionsOptional);
            }
            if ((numberOfInsertionWorkersPerCollectionOptional = instance.numberOfInsertionWorkersPerCollection()).isPresent()) {
                this.numberOfInsertionWorkersPerCollection(numberOfInsertionWorkersPerCollectionOptional);
            }
            if ((writeConcernOptional = instance.writeConcern()).isPresent()) {
                this.writeConcern(writeConcernOptional);
            }
            this.objectCheck(instance.objectCheck());
            this.oplogReplay(instance.oplogReplay());
            this.restoreDbUsersAndRoles(instance.restoreDbUsersAndRoles());
            this.gzip(instance.gzip());
            this.dropCollection(instance.dropCollection());
            this.noIndexRestore(instance.noIndexRestore());
            this.noOptionsRestore(instance.noOptionsRestore());
            this.keepIndexVersion(instance.keepIndexVersion());
            this.maintainInsertionOrder(instance.maintainInsertionOrder());
            this.stopOnError(instance.stopOnError());
            this.bypassDocumentValidation(instance.bypassDocumentValidation());
            return this;
        }

        public final Builder verbose(boolean verbose) {
            this.verbose = verbose;
            this.optBits |= 1L;
            return this;
        }

        public final Builder databaseName(String databaseName) {
            this.databaseName = Objects.requireNonNull(databaseName, "databaseName");
            return this;
        }

        public final Builder databaseName(Optional<String> databaseName) {
            this.databaseName = databaseName.orElse(null);
            return this;
        }

        public final Builder collectionName(String collectionName) {
            this.collectionName = Objects.requireNonNull(collectionName, "collectionName");
            return this;
        }

        public final Builder collectionName(Optional<String> collectionName) {
            this.collectionName = collectionName.orElse(null);
            return this;
        }

        public final Builder oplogLimit(long oplogLimit) {
            this.oplogLimit = oplogLimit;
            return this;
        }

        public final Builder oplogLimit(OptionalLong oplogLimit) {
            this.oplogLimit = oplogLimit.isPresent() ? Long.valueOf(oplogLimit.getAsLong()) : null;
            return this;
        }

        public final Builder archive(String archive) {
            this.archive = Objects.requireNonNull(archive, "archive");
            return this;
        }

        public final Builder archive(Optional<String> archive) {
            this.archive = archive.orElse(null);
            return this;
        }

        public final Builder dir(String dir) {
            this.dir = Objects.requireNonNull(dir, "dir");
            return this;
        }

        public final Builder dir(Optional<String> dir) {
            this.dir = dir.orElse(null);
            return this;
        }

        public final Builder numberOfParallelCollections(int numberOfParallelCollections) {
            this.numberOfParallelCollections = numberOfParallelCollections;
            return this;
        }

        public final Builder numberOfParallelCollections(OptionalInt numberOfParallelCollections) {
            this.numberOfParallelCollections = numberOfParallelCollections.isPresent() ? Integer.valueOf(numberOfParallelCollections.getAsInt()) : null;
            return this;
        }

        public final Builder numberOfInsertionWorkersPerCollection(int numberOfInsertionWorkersPerCollection) {
            this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection;
            return this;
        }

        public final Builder numberOfInsertionWorkersPerCollection(OptionalInt numberOfInsertionWorkersPerCollection) {
            this.numberOfInsertionWorkersPerCollection = numberOfInsertionWorkersPerCollection.isPresent() ? Integer.valueOf(numberOfInsertionWorkersPerCollection.getAsInt()) : null;
            return this;
        }

        public final Builder writeConcern(String writeConcern) {
            this.writeConcern = Objects.requireNonNull(writeConcern, "writeConcern");
            return this;
        }

        public final Builder writeConcern(Optional<String> writeConcern) {
            this.writeConcern = writeConcern.orElse(null);
            return this;
        }

        public final Builder objectCheck(boolean objectCheck) {
            this.objectCheck = objectCheck;
            this.optBits |= 2L;
            return this;
        }

        public final Builder oplogReplay(boolean oplogReplay) {
            this.oplogReplay = oplogReplay;
            this.optBits |= 4L;
            return this;
        }

        public final Builder restoreDbUsersAndRoles(boolean restoreDbUsersAndRoles) {
            this.restoreDbUsersAndRoles = restoreDbUsersAndRoles;
            this.optBits |= 8L;
            return this;
        }

        public final Builder gzip(boolean gzip) {
            this.gzip = gzip;
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder dropCollection(boolean dropCollection) {
            this.dropCollection = dropCollection;
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder noIndexRestore(boolean noIndexRestore) {
            this.noIndexRestore = noIndexRestore;
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder noOptionsRestore(boolean noOptionsRestore) {
            this.noOptionsRestore = noOptionsRestore;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder keepIndexVersion(boolean keepIndexVersion) {
            this.keepIndexVersion = keepIndexVersion;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder maintainInsertionOrder(boolean maintainInsertionOrder) {
            this.maintainInsertionOrder = maintainInsertionOrder;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder stopOnError(boolean stopOnError) {
            this.stopOnError = stopOnError;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder bypassDocumentValidation(boolean bypassDocumentValidation) {
            this.bypassDocumentValidation = bypassDocumentValidation;
            this.optBits |= 0x800L;
            return this;
        }

        public ImmutableMongoRestoreArguments build() {
            return new ImmutableMongoRestoreArguments(this);
        }

        private boolean verboseIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean objectCheckIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean oplogReplayIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean restoreDbUsersAndRolesIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean gzipIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean dropCollectionIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean noIndexRestoreIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean noOptionsRestoreIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean keepIndexVersionIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean maintainInsertionOrderIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean stopOnErrorIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean bypassDocumentValidationIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }
    }

    private final class InitShim {
        private byte verboseBuildStage = 0;
        private boolean verbose;
        private byte objectCheckBuildStage = 0;
        private boolean objectCheck;
        private byte oplogReplayBuildStage = 0;
        private boolean oplogReplay;
        private byte restoreDbUsersAndRolesBuildStage = 0;
        private boolean restoreDbUsersAndRoles;
        private byte gzipBuildStage = 0;
        private boolean gzip;
        private byte dropCollectionBuildStage = 0;
        private boolean dropCollection;
        private byte noIndexRestoreBuildStage = 0;
        private boolean noIndexRestore;
        private byte noOptionsRestoreBuildStage = 0;
        private boolean noOptionsRestore;
        private byte keepIndexVersionBuildStage = 0;
        private boolean keepIndexVersion;
        private byte maintainInsertionOrderBuildStage = 0;
        private boolean maintainInsertionOrder;
        private byte stopOnErrorBuildStage = 0;
        private boolean stopOnError;
        private byte bypassDocumentValidationBuildStage = 0;
        private boolean bypassDocumentValidation;

        private InitShim() {
        }

        boolean verbose() {
            if (this.verboseBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verboseBuildStage == 0) {
                this.verboseBuildStage = (byte)-1;
                this.verbose = ImmutableMongoRestoreArguments.super.verbose();
                this.verboseBuildStage = 1;
            }
            return this.verbose;
        }

        void verbose(boolean verbose) {
            this.verbose = verbose;
            this.verboseBuildStage = 1;
        }

        boolean objectCheck() {
            if (this.objectCheckBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.objectCheckBuildStage == 0) {
                this.objectCheckBuildStage = (byte)-1;
                this.objectCheck = ImmutableMongoRestoreArguments.super.objectCheck();
                this.objectCheckBuildStage = 1;
            }
            return this.objectCheck;
        }

        void objectCheck(boolean objectCheck) {
            this.objectCheck = objectCheck;
            this.objectCheckBuildStage = 1;
        }

        boolean oplogReplay() {
            if (this.oplogReplayBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.oplogReplayBuildStage == 0) {
                this.oplogReplayBuildStage = (byte)-1;
                this.oplogReplay = ImmutableMongoRestoreArguments.super.oplogReplay();
                this.oplogReplayBuildStage = 1;
            }
            return this.oplogReplay;
        }

        void oplogReplay(boolean oplogReplay) {
            this.oplogReplay = oplogReplay;
            this.oplogReplayBuildStage = 1;
        }

        boolean restoreDbUsersAndRoles() {
            if (this.restoreDbUsersAndRolesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.restoreDbUsersAndRolesBuildStage == 0) {
                this.restoreDbUsersAndRolesBuildStage = (byte)-1;
                this.restoreDbUsersAndRoles = ImmutableMongoRestoreArguments.super.restoreDbUsersAndRoles();
                this.restoreDbUsersAndRolesBuildStage = 1;
            }
            return this.restoreDbUsersAndRoles;
        }

        void restoreDbUsersAndRoles(boolean restoreDbUsersAndRoles) {
            this.restoreDbUsersAndRoles = restoreDbUsersAndRoles;
            this.restoreDbUsersAndRolesBuildStage = 1;
        }

        boolean gzip() {
            if (this.gzipBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.gzipBuildStage == 0) {
                this.gzipBuildStage = (byte)-1;
                this.gzip = ImmutableMongoRestoreArguments.super.gzip();
                this.gzipBuildStage = 1;
            }
            return this.gzip;
        }

        void gzip(boolean gzip) {
            this.gzip = gzip;
            this.gzipBuildStage = 1;
        }

        boolean dropCollection() {
            if (this.dropCollectionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.dropCollectionBuildStage == 0) {
                this.dropCollectionBuildStage = (byte)-1;
                this.dropCollection = ImmutableMongoRestoreArguments.super.dropCollection();
                this.dropCollectionBuildStage = 1;
            }
            return this.dropCollection;
        }

        void dropCollection(boolean dropCollection) {
            this.dropCollection = dropCollection;
            this.dropCollectionBuildStage = 1;
        }

        boolean noIndexRestore() {
            if (this.noIndexRestoreBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noIndexRestoreBuildStage == 0) {
                this.noIndexRestoreBuildStage = (byte)-1;
                this.noIndexRestore = ImmutableMongoRestoreArguments.super.noIndexRestore();
                this.noIndexRestoreBuildStage = 1;
            }
            return this.noIndexRestore;
        }

        void noIndexRestore(boolean noIndexRestore) {
            this.noIndexRestore = noIndexRestore;
            this.noIndexRestoreBuildStage = 1;
        }

        boolean noOptionsRestore() {
            if (this.noOptionsRestoreBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noOptionsRestoreBuildStage == 0) {
                this.noOptionsRestoreBuildStage = (byte)-1;
                this.noOptionsRestore = ImmutableMongoRestoreArguments.super.noOptionsRestore();
                this.noOptionsRestoreBuildStage = 1;
            }
            return this.noOptionsRestore;
        }

        void noOptionsRestore(boolean noOptionsRestore) {
            this.noOptionsRestore = noOptionsRestore;
            this.noOptionsRestoreBuildStage = 1;
        }

        boolean keepIndexVersion() {
            if (this.keepIndexVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.keepIndexVersionBuildStage == 0) {
                this.keepIndexVersionBuildStage = (byte)-1;
                this.keepIndexVersion = ImmutableMongoRestoreArguments.super.keepIndexVersion();
                this.keepIndexVersionBuildStage = 1;
            }
            return this.keepIndexVersion;
        }

        void keepIndexVersion(boolean keepIndexVersion) {
            this.keepIndexVersion = keepIndexVersion;
            this.keepIndexVersionBuildStage = 1;
        }

        boolean maintainInsertionOrder() {
            if (this.maintainInsertionOrderBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maintainInsertionOrderBuildStage == 0) {
                this.maintainInsertionOrderBuildStage = (byte)-1;
                this.maintainInsertionOrder = ImmutableMongoRestoreArguments.super.maintainInsertionOrder();
                this.maintainInsertionOrderBuildStage = 1;
            }
            return this.maintainInsertionOrder;
        }

        void maintainInsertionOrder(boolean maintainInsertionOrder) {
            this.maintainInsertionOrder = maintainInsertionOrder;
            this.maintainInsertionOrderBuildStage = 1;
        }

        boolean stopOnError() {
            if (this.stopOnErrorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.stopOnErrorBuildStage == 0) {
                this.stopOnErrorBuildStage = (byte)-1;
                this.stopOnError = ImmutableMongoRestoreArguments.super.stopOnError();
                this.stopOnErrorBuildStage = 1;
            }
            return this.stopOnError;
        }

        void stopOnError(boolean stopOnError) {
            this.stopOnError = stopOnError;
            this.stopOnErrorBuildStage = 1;
        }

        boolean bypassDocumentValidation() {
            if (this.bypassDocumentValidationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.bypassDocumentValidationBuildStage == 0) {
                this.bypassDocumentValidationBuildStage = (byte)-1;
                this.bypassDocumentValidation = ImmutableMongoRestoreArguments.super.bypassDocumentValidation();
                this.bypassDocumentValidationBuildStage = 1;
            }
            return this.bypassDocumentValidation;
        }

        void bypassDocumentValidation(boolean bypassDocumentValidation) {
            this.bypassDocumentValidation = bypassDocumentValidation;
            this.bypassDocumentValidationBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.verboseBuildStage == -1) {
                attributes.add("verbose");
            }
            if (this.objectCheckBuildStage == -1) {
                attributes.add("objectCheck");
            }
            if (this.oplogReplayBuildStage == -1) {
                attributes.add("oplogReplay");
            }
            if (this.restoreDbUsersAndRolesBuildStage == -1) {
                attributes.add("restoreDbUsersAndRoles");
            }
            if (this.gzipBuildStage == -1) {
                attributes.add("gzip");
            }
            if (this.dropCollectionBuildStage == -1) {
                attributes.add("dropCollection");
            }
            if (this.noIndexRestoreBuildStage == -1) {
                attributes.add("noIndexRestore");
            }
            if (this.noOptionsRestoreBuildStage == -1) {
                attributes.add("noOptionsRestore");
            }
            if (this.keepIndexVersionBuildStage == -1) {
                attributes.add("keepIndexVersion");
            }
            if (this.maintainInsertionOrderBuildStage == -1) {
                attributes.add("maintainInsertionOrder");
            }
            if (this.stopOnErrorBuildStage == -1) {
                attributes.add("stopOnError");
            }
            if (this.bypassDocumentValidationBuildStage == -1) {
                attributes.add("bypassDocumentValidation");
            }
            return "Cannot build MongoRestoreArguments, attribute initializers form cycle " + attributes;
        }
    }
}

