/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.runtime;

import de.flapdoodle.embed.mongo.config.IMongosConfig;
import de.flapdoodle.embed.mongo.distribution.Feature;
import de.flapdoodle.embed.mongo.runtime.AbstractMongo;
import de.flapdoodle.embed.process.extract.IExtractedFileSet;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class Mongos
extends AbstractMongo {
    public static List<String> getCommandLine(IMongosConfig config, IExtractedFileSet files) throws UnknownHostException {
        ArrayList<String> ret = new ArrayList<String>();
        ret.add(files.executable().getAbsolutePath());
        if (!config.version().enabled(Feature.NO_CHUNKSIZE_ARG)) {
            ret.add("--chunkSize");
            ret.add("1");
        }
        if (config.cmdOptions().isVerbose()) {
            ret.add("-v");
        }
        Mongos.applyDefaultOptions(config, ret);
        Mongos.applyNet(config, ret);
        if (config.getConfigDB() != null) {
            ret.add("--configdb");
            if (config.version().enabled(Feature.MONGOS_CONFIGDB_SET_STYLE)) {
                if (config.replicaSet().isEmpty()) {
                    throw new IllegalArgumentException("you must define a replicaSet");
                }
                ret.add(config.replicaSet() + "/" + config.getConfigDB());
            } else {
                ret.add(config.getConfigDB());
            }
        }
        if (config.args() != null && !config.args().isEmpty()) {
            for (String key : config.args().keySet()) {
                ret.add(key);
                String val = config.args().get(key);
                if (val == null || val.isEmpty()) continue;
                ret.add(val);
            }
        }
        return ret;
    }
}

