/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.MapTypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Type;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMapTypeCodec<V>
extends MapTypeCodec<String, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMapTypeCodec.class);

    public SimpleMapTypeCodec(Class<Map<String, V>> encoderClass, Type valueType, TypeCodecRegistry typeCodecRegistry) {
        super(encoderClass, valueType, typeCodecRegistry);
    }

    public Map<String, V> decode(BsonReader reader, DecoderContext decoderContext) {
        Map map = null;
        if (BsonType.NULL.equals((Object)reader.getCurrentBsonType())) {
            reader.skipValue();
        } else if (BsonType.DOCUMENT.equals((Object)reader.getCurrentBsonType())) {
            map = (Map)this.newInstance();
            reader.readStartDocument();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                String key = reader.readName();
                Object value = null;
                if (BsonType.NULL.equals((Object)reader.getCurrentBsonType())) {
                    reader.skipValue();
                } else {
                    value = this.valueTypeCodec.decode(reader, decoderContext);
                }
                map.put(key, value);
            }
            reader.readEndDocument();
        } else {
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)BsonType.DOCUMENT, (Object)reader.getCurrentBsonType());
            reader.skipValue();
        }
        return map;
    }

    public void encode(BsonWriter writer, Map<String, V> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry<String, V> entry : map.entrySet()) {
            writer.writeName(entry.getKey());
            V value = entry.getValue();
            if (value != null) {
                this.valueTypeCodec.encode(writer, value, encoderContext);
                continue;
            }
            writer.writeNull();
        }
        writer.writeEndDocument();
    }
}

