/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.MapTypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Type;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexMapTypeCodec<K, V>
extends MapTypeCodec<K, V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComplexMapTypeCodec.class);
    final Codec<K> keyTypeCodec;

    public ComplexMapTypeCodec(Class<Map<K, V>> encoderClass, Type keyType, Type valueType, TypeCodecRegistry typeCodecRegistry) {
        super(encoderClass, valueType, typeCodecRegistry);
        this.keyTypeCodec = typeCodecRegistry.getCodec(keyType);
    }

    public Map<K, V> decode(BsonReader reader, DecoderContext decoderContext) {
        Map map = null;
        if (BsonType.NULL.equals((Object)reader.getCurrentBsonType())) {
            reader.skipValue();
        } else if (BsonType.ARRAY.equals((Object)reader.getCurrentBsonType())) {
            map = (Map)this.newInstance();
            reader.readStartArray();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (BsonType.DOCUMENT.equals((Object)reader.getCurrentBsonType())) {
                    reader.readStartDocument();
                    reader.readName();
                    Object key = this.keyTypeCodec.decode(reader, decoderContext);
                    reader.readName();
                    Object value = this.valueTypeCodec.decode(reader, decoderContext);
                    map.put(key, value);
                    reader.readEndDocument();
                    continue;
                }
                LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)BsonType.DOCUMENT, (Object)reader.getCurrentBsonType());
                reader.skipValue();
            }
            reader.readEndArray();
        } else {
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)BsonType.ARRAY, (Object)reader.getCurrentBsonType());
            reader.skipValue();
        }
        return map;
    }

    public void encode(BsonWriter writer, Map<K, V> map, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (Map.Entry<K, V> entry : map.entrySet()) {
            writer.writeStartDocument();
            writer.writeName("key");
            this.keyTypeCodec.encode(writer, entry.getKey(), encoderContext);
            writer.writeName("value");
            V value = entry.getValue();
            if (value != null) {
                this.valueTypeCodec.encode(writer, value, encoderContext);
            } else {
                writer.writeNull();
            }
            writer.writeEndDocument();
        }
        writer.writeEndArray();
    }
}

