/*
 * Decompiled with CFR 0.152.
 */
package de.bild.codec;

import de.bild.codec.ReflectionHelper;
import de.bild.codec.TypeCodec;
import de.bild.codec.TypeCodecRegistry;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArrayCodec<T>
implements TypeCodec<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArrayCodec.class);
    final Codec<Object> arrayElementCodec;
    final Class<T> arrayClazz;

    public ArrayCodec(Type type, TypeCodecRegistry typeCodecRegistry) {
        if (TypeUtils.isArrayType((Type)type)) {
            this.arrayClazz = ReflectionHelper.extractRawClass(type);
            if (type instanceof GenericArrayType) {
                GenericArrayType genericArrayType = (GenericArrayType)type;
                this.arrayElementCodec = typeCodecRegistry.getCodec(genericArrayType.getGenericComponentType());
            } else {
                this.arrayElementCodec = typeCodecRegistry.getCodec(this.arrayClazz.getComponentType());
            }
        } else {
            throw new IllegalArgumentException("Unknown array type?!" + type);
        }
    }

    public void encode(BsonWriter writer, T array, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (int i = 0; i < Array.getLength(array); ++i) {
            Object value = Array.get(array, i);
            if (value != null) {
                this.arrayElementCodec.encode(writer, value, encoderContext);
                continue;
            }
            writer.writeNull();
        }
        writer.writeEndArray();
    }

    public T decode(BsonReader reader, DecoderContext decoderContext) {
        Object array = null;
        if (BsonType.ARRAY.equals((Object)reader.getCurrentBsonType())) {
            ArrayList<Object> list = new ArrayList<Object>();
            reader.readStartArray();
            while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                if (BsonType.NULL.equals((Object)reader.getCurrentBsonType())) {
                    reader.skipValue();
                    list.add(null);
                    continue;
                }
                list.add(this.arrayElementCodec.decode(reader, decoderContext));
            }
            reader.readEndArray();
            array = Array.newInstance(this.arrayClazz.getComponentType(), list.size());
            for (int i = 0; i < list.size(); ++i) {
                Array.set(array, i, list.get(i));
            }
        } else {
            LOGGER.warn("Expected {} from reader but got {}. Skipping value.", (Object)BsonType.ARRAY, (Object)reader.getCurrentBsonType());
            reader.skipValue();
        }
        return (T)array;
    }

    public Class<T> getEncoderClass() {
        return this.arrayClazz;
    }
}

