/*
 * Decompiled with CFR 0.152.
 */
package de.articdive.jnoise.core.api.functions;

import de.articdive.jnoise.core.util.MathUtil;

@FunctionalInterface
public interface Combiner {
    public static final Combiner ADD = Double::sum;
    public static final Combiner MULTIPLY = (a, b) -> a * b;
    public static final Combiner MAX = Math::max;
    public static final Combiner MIN = Math::min;
    public static final Combiner POW = Math::pow;
    public static final Combiner EXPONENTIAL_SMOOTH_MIN = (a, b) -> {
        double res = MathUtil.exp2(-32.0 * a) + MathUtil.exp2(-32.0 * b);
        return -MathUtil.log2(res) / 32.0;
    };
    public static final Combiner POWER_SMOOTH_MIN = (a, b) -> {
        a = Math.pow(a, 8.0);
        b = Math.pow(b, 8.0);
        return Math.pow(a * b / (a + b), 0.125);
    };
    public static final Combiner POLYNOMIAL_SMOOTH_MIN = (a, b) -> {
        double h = Math.max(0.1 - Math.abs(a - b), 0.0) / 0.1;
        return Math.min(a, b) - h * h * 0.1 * 0.25;
    };

    @Deprecated(since="4.1.0", forRemoval=true)
    default public double combine(double a, double b) {
        return this.applyTo(a, b);
    }

    public double applyTo(double var1, double var3);
}

