/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.transaction;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.xa.XAResource;

public class TxTransaction
implements Transaction {
    private final ArrayList<Synchronization> synchronizations = new ArrayList();
    private volatile Connection connection;
    private volatile int status = 6;

    TxTransaction() {
    }

    public int getStatus() throws SystemException {
        return this.status;
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        if (this.status == 6) {
            throw new IllegalStateException("transaction hasn't started yet");
        }
        if (this.isDone()) {
            throw new IllegalStateException("transaction is done, cannot commit it");
        }
        if (this.connection != null && this.status == 0) {
            try {
                this.synchronizations.forEach(Synchronization::beforeCompletion);
                this.connection.commit();
                this.synchronizations.forEach(s -> s.afterCompletion(3));
            }
            catch (SQLException e) {
                SystemException systemException = new SystemException("Exception committing connection " + this.connection.toString());
                systemException.initCause((Throwable)e);
                throw systemException;
            }
            finally {
                this.cleanup();
            }
        }
    }

    public void rollback() throws IllegalStateException, SystemException {
        if (this.connection != null && this.status == 0) {
            try {
                this.connection.rollback();
            }
            catch (SQLException e) {
                SystemException systemException = new SystemException("Exception committing connection " + this.connection.toString());
                systemException.initCause((Throwable)e);
                throw systemException;
            }
            finally {
                this.cleanup();
            }
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        throw new SystemException("setRollbackOnly() operation is not supported");
    }

    public boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
        throw new SystemException("delistResource() operation is not supported");
    }

    public boolean enlistResource(XAResource xaRes) throws RollbackException, IllegalStateException, SystemException {
        throw new SystemException("enlistResource() operation is not supported");
    }

    public void registerSynchronization(Synchronization sync) throws RollbackException, IllegalStateException, SystemException {
        this.synchronizations.add(sync);
    }

    void setActive() {
        if (this.status != 6) {
            throw new IllegalStateException("transaction has already started");
        }
        this.status = 0;
    }

    Connection getConnection() {
        return this.connection;
    }

    void setConnection(Connection connection) {
        this.connection = connection;
    }

    private void cleanup() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.synchronizations.clear();
        this.status = 6;
    }

    private boolean isDone() {
        switch (this.status) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                return true;
            }
        }
        return false;
    }
}

