/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.sansorm.internal;

import com.zaxxer.sansorm.internal.FieldColumnInfo;
import com.zaxxer.sansorm.internal.Introspected;
import com.zaxxer.sansorm.internal.Introspector;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

class OrmBase {
    private static final Map<String, String> csvCache = new ConcurrentHashMap<String, String>();

    protected OrmBase() {
    }

    protected static void populateStatementParameters(PreparedStatement stmt, Object ... args) throws SQLException {
        ParameterMetaData parameterMetaData = stmt.getParameterMetaData();
        int paramCount = parameterMetaData.getParameterCount();
        if (paramCount > 0 && args.length < paramCount) {
            throw new RuntimeException("Too few parameters supplied for query");
        }
        for (int column = paramCount; column > 0; --column) {
            int parameterType = parameterMetaData.getParameterType(column);
            Object object = OrmBase.mapSqlType(args[column - 1], parameterType);
            stmt.setObject(column, object, parameterType);
        }
    }

    public static <T> String getColumnsCsv(Class<T> clazz, String ... tablePrefix) {
        String cacheKey = tablePrefix == null || tablePrefix.length == 0 ? clazz.getName() : tablePrefix[0] + clazz.getName();
        return csvCache.computeIfAbsent(cacheKey, key -> {
            FieldColumnInfo[] selectableFields;
            StringBuilder sb = new StringBuilder();
            Introspected introspected = Introspector.getIntrospected(clazz);
            for (FieldColumnInfo selectableField : selectableFields = introspected.getSelectableFcInfos()) {
                sb.append(selectableField.getFullyQualifiedDelimitedFieldName(tablePrefix)).append(',');
            }
            return sb.deleteCharAt(sb.length() - 1).toString();
        });
    }

    public static <T> String getColumnsCsvExclude(Class<T> clazz, String ... excludeColumns) {
        FieldColumnInfo[] selectableFields;
        HashSet<String> excludes = new HashSet<String>(Arrays.asList(excludeColumns));
        StringBuilder sb = new StringBuilder();
        Introspected introspected = Introspector.getIntrospected(clazz);
        for (FieldColumnInfo selectableField : selectableFields = introspected.getSelectableFcInfos()) {
            if (excludes.contains(selectableField.getCaseSensitiveColumnName())) continue;
            sb.append(selectableField.getFullyQualifiedDelimitedFieldName(new String[0])).append(',');
        }
        return sb.deleteCharAt(sb.length() - 1).toString();
    }

    protected static Object mapSqlType(Object object, int sqlType) {
        switch (sqlType) {
            case 93: {
                if (object instanceof Timestamp) {
                    return object;
                }
                if (!(object instanceof Date)) break;
                return new Timestamp(((Date)object).getTime());
            }
            case 3: {
                if (!(object instanceof BigInteger)) break;
                return new BigDecimal((BigInteger)object);
            }
            case 5: {
                if (!(object instanceof Boolean)) break;
                return (Boolean)object != false ? (short)1 : 0;
            }
        }
        return object;
    }

    protected static boolean isIgnoredColumn(Set<String> ignoredColumns, String columnName) {
        return ignoredColumns.stream().anyMatch(s -> s.equalsIgnoreCase(columnName));
    }
}

