/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.HikariConfig;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyBeanSetter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyBeanSetter.class);

    public static void setTargetFromProperties(Object object, Properties properties) {
        if (object == null || properties == null) {
            return;
        }
        for (Object object2 : properties.keySet()) {
            String string = object2.toString();
            Object object3 = properties.get(object2);
            if (object instanceof HikariConfig && string.startsWith("dataSource.")) {
                HikariConfig hikariConfig = (HikariConfig)object;
                hikariConfig.addDataSourceProperty(string.substring("dataSource.".length()), object3);
                continue;
            }
            PropertyBeanSetter.setProperty(object, string, object3);
        }
    }

    private static void setProperty(Object object, String string, Object object2) {
        String string2 = "set" + string.substring(0, 1).toUpperCase() + string.substring(1);
        try {
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(string, object.getClass(), null, string2);
            Method method = propertyDescriptor.getWriteMethod();
            Class<?> clazz = method.getParameterTypes()[0];
            if (clazz == Integer.TYPE) {
                method.invoke(object, Integer.parseInt(object2.toString()));
            } else if (clazz == Long.TYPE) {
                method.invoke(object, Long.parseLong(object2.toString()));
            } else if (clazz == Boolean.TYPE) {
                method.invoke(object, Boolean.parseBoolean(object2.toString()));
            } else if (clazz == String.class) {
                method.invoke(object, object2.toString());
            } else {
                method.invoke(object, object2);
            }
        }
        catch (IntrospectionException introspectionException) {
            LOGGER.error("Property {} is does not exist on target class {}", (Object)string, object.getClass());
            throw new RuntimeException(introspectionException);
        }
        catch (Exception exception) {
            LOGGER.error("Exception setting property {} on target class {}", new Object[]{string, object.getClass(), exception});
            throw new RuntimeException(exception);
        }
    }
}

