/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.proxy;

import java.util.TimerTask;
import org.slf4j.LoggerFactory;

public class LeakTask
extends TimerTask {
    private final long leakTime;
    private StackTraceElement[] stackTrace;

    public LeakTask(StackTraceElement[] stackTraceElementArray, long l) {
        this.stackTrace = stackTraceElementArray;
        this.leakTime = System.currentTimeMillis() + l;
    }

    @Override
    public void run() {
        if (System.currentTimeMillis() > this.leakTime) {
            Exception exception = new Exception();
            exception.setStackTrace(this.stackTrace);
            LoggerFactory.getLogger(LeakTask.class).warn("Connection leak detection triggered, stack trace follows", (Throwable)exception);
            this.stackTrace = null;
        }
    }

    @Override
    public boolean cancel() {
        boolean bl = super.cancel();
        if (bl) {
            this.stackTrace = null;
        }
        return bl;
    }
}

