/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.javassist;

import com.zaxxer.hikari.javassist.HikariClassTransformer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariClassScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariClassScanner.class);
    private HikariClassTransformer transformer;
    private Map<String, Set<String>> codex;
    private String shadedCodexMapping;

    public HikariClassScanner(HikariClassTransformer hikariClassTransformer, String string) {
        this.transformer = hikariClassTransformer;
        this.shadedCodexMapping = string;
    }

    public boolean scanClasses(String string) {
        try {
            long l = System.currentTimeMillis();
            if (!this.loadCodex()) {
                LOGGER.warn("Unable to load instrumentation codex.  Please report at http://github.com/brettwooldridge/HikariCP.");
                LOGGER.info("Using delegation instead of instrumentation");
                return false;
            }
            String string2 = this.getKeyPrefix(string);
            if (string2 == null) {
                LOGGER.warn("DataSource {} not found in the instrumentation codex.  Please report at http://github.com/brettwooldridge/HikariCP.", (Object)string);
                LOGGER.info("Using delegation instead of instrumentation");
                return false;
            }
            HashSet hashSet = (HashSet)this.codex.get(string2 + ".baseConnection");
            this.loadClasses(hashSet, 1);
            hashSet = (HashSet)this.codex.get(string2 + ".subConnection");
            this.loadClasses(hashSet, 6);
            hashSet = (HashSet)this.codex.get(string2 + ".baseStatement");
            this.loadClasses(hashSet, 2);
            hashSet = (HashSet)this.codex.get(string2 + ".subStatement");
            this.loadClasses(hashSet, 7);
            hashSet = (HashSet)this.codex.get(string2 + ".basePreparedStatement");
            this.loadClasses(hashSet, 3);
            hashSet = (HashSet)this.codex.get(string2 + ".subPreparedStatement");
            this.loadClasses(hashSet, 8);
            hashSet = (HashSet)this.codex.get(string2 + ".baseCallableStatement");
            this.loadClasses(hashSet, 4);
            hashSet = (HashSet)this.codex.get(string2 + ".subCallableStatement");
            this.loadClasses(hashSet, 9);
            hashSet = (HashSet)this.codex.get(string2 + ".baseResultSet");
            this.loadClasses(hashSet, 5);
            hashSet = (HashSet)this.codex.get(string2 + ".subResultSet");
            this.loadClasses(hashSet, 10);
            LOGGER.info("Instrumented JDBC classes in {}ms.", (Object)(System.currentTimeMillis() - l));
            return true;
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to instrument classes", (Throwable)exception);
            return false;
        }
    }

    private String getKeyPrefix(String string) {
        if (this.shadedCodexMapping == null) {
            HashSet hashSet = (HashSet)this.codex.get(string);
            return hashSet == null ? null : (String)hashSet.iterator().next();
        }
        String[] stringArray = this.shadedCodexMapping.split(":");
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        for (String string4 : this.codex.keySet()) {
            if (!string4.replace(string2, string3).equals(string)) continue;
            HashSet hashSet = (HashSet)this.codex.get(string4);
            return (String)hashSet.iterator().next();
        }
        return null;
    }

    private boolean loadCodex() throws IOException {
        String string;
        this.codex = new HashMap<String, Set<String>>();
        InputStream inputStream = this.getClass().getResourceAsStream("/META-INF/codex.properties");
        if (inputStream == null) {
            return false;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        do {
            if ((string = bufferedReader.readLine()) == null || (string = string.trim()).startsWith("#") || string.length() == 0) continue;
            String[] stringArray = string.split("=");
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            HashSet hashSet = (HashSet)this.codex.get(string2);
            if (hashSet == null) {
                HashSet<String> hashSet2 = new HashSet<String>();
                hashSet2.add(string3);
                this.codex.put(string2, hashSet2);
                continue;
            }
            hashSet.add(string3);
        } while (string != null);
        return true;
    }

    private void loadClasses(HashSet<String> hashSet, int n) throws ClassNotFoundException {
        if (hashSet == null) {
            return;
        }
        if (this.shadedCodexMapping != null) {
            String[] stringArray = this.shadedCodexMapping.split(":");
            String string = stringArray[0];
            Object object = stringArray[1];
            HashSet<String> hashSet2 = new HashSet<String>();
            for (String string2 : hashSet) {
                hashSet2.add(string2.replace(string, (CharSequence)object));
            }
            hashSet = hashSet2;
        }
        this.transformer.setScanClass(hashSet, n);
        for (String string : hashSet) {
            this.getClass().getClassLoader().loadClass(string);
        }
    }
}

