/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariMBeanElf;
import com.zaxxer.hikari.HikariPoolMBean;
import com.zaxxer.hikari.javassist.AgentRegistrationElf;
import com.zaxxer.hikari.proxy.IHikariConnectionProxy;
import com.zaxxer.hikari.proxy.JavassistProxyFactoryFactory;
import com.zaxxer.hikari.util.PropertyBeanSetter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariPool
implements HikariPoolMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariPool.class);
    final DataSource dataSource;
    private final HikariConfig configuration;
    private final LinkedTransferQueue<IHikariConnectionProxy> idleConnections;
    private final AtomicInteger totalConnections;
    private final AtomicInteger idleConnectionCount;
    private final AtomicBoolean backgroundFillQueued;
    private final long leakDetectionThreshold;
    private final boolean jdbc4ConnectionTest;
    private final boolean isAutoCommit;
    private final boolean delegationProxies;
    private int transactionIsolation;
    private final Timer houseKeepingTimer;

    HikariPool(HikariConfig hikariConfig) {
        hikariConfig.validate();
        this.configuration = hikariConfig;
        this.totalConnections = new AtomicInteger();
        this.idleConnectionCount = new AtomicInteger();
        this.backgroundFillQueued = new AtomicBoolean();
        this.idleConnections = new LinkedTransferQueue();
        this.jdbc4ConnectionTest = hikariConfig.isJdbc4ConnectionTest();
        this.leakDetectionThreshold = hikariConfig.getLeakDetectionThreshold();
        this.isAutoCommit = hikariConfig.isAutoCommit();
        this.transactionIsolation = hikariConfig.getTransactionIsolation();
        String string = hikariConfig.getDataSourceClassName();
        try {
            String string2 = hikariConfig.getShadedCodexMapping();
            boolean bl = this.delegationProxies = !hikariConfig.isUseInstrumentation() || !AgentRegistrationElf.loadTransformerAgent(string, string2);
            if (this.delegationProxies) {
                LOGGER.info("Using Javassist delegate-based proxies.");
            }
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
            this.dataSource = (DataSource)clazz.newInstance();
            PropertyBeanSetter.setTargetFromProperties(this.dataSource, hikariConfig.getDataSourceProperties());
        }
        catch (Exception exception) {
            throw new RuntimeException("Could not create datasource class: " + string, exception);
        }
        HikariMBeanElf.registerMBeans(hikariConfig, this);
        this.houseKeepingTimer = new Timer("Hikari Housekeeping Timer", true);
        long l = hikariConfig.getIdleTimeout();
        if (l > 0L || hikariConfig.getMaxLifetime() > 0L) {
            this.houseKeepingTimer.scheduleAtFixedRate((TimerTask)new HouseKeeper(), TimeUnit.SECONDS.toMillis(30L), TimeUnit.SECONDS.toMillis(30L));
        }
        this.fillPool();
    }

    /*
     * Exception decompiling
     */
    Connection getConnection() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[DOLOOP]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void releaseConnection(IHikariConnectionProxy iHikariConnectionProxy) {
        this.rollbackConnection(iHikariConnectionProxy);
        if (!iHikariConnectionProxy._isBrokenConnection()) {
            iHikariConnectionProxy._markLastAccess();
            this.idleConnectionCount.incrementAndGet();
            this.idleConnections.put(iHikariConnectionProxy);
        } else {
            this.closeConnection(iHikariConnectionProxy);
        }
    }

    void shutdown() {
    }

    @Override
    public int getActiveConnections() {
        return Math.min(this.configuration.getMaximumPoolSize(), this.totalConnections.get() - this.idleConnectionCount.get());
    }

    @Override
    public int getIdleConnections() {
        return this.idleConnectionCount.get();
    }

    @Override
    public int getTotalConnections() {
        return this.totalConnections.get();
    }

    @Override
    public int getThreadsAwaitingConnection() {
        return this.idleConnections.getWaitingConsumerCount();
    }

    @Override
    public void closeIdleConnections() {
        IHikariConnectionProxy iHikariConnectionProxy;
        int n = this.idleConnectionCount.get();
        for (int i = 0; i < n && (iHikariConnectionProxy = this.idleConnections.poll()) != null; ++i) {
            this.idleConnectionCount.decrementAndGet();
            this.closeConnection(iHikariConnectionProxy);
        }
    }

    private void fillPool() {
        int n = this.configuration.getMinimumPoolSize() * this.configuration.getAcquireRetries();
        while (this.totalConnections.get() < this.configuration.getMinimumPoolSize() && n-- > 0) {
            this.addConnection();
        }
    }

    private synchronized void addConnections(AddConnectionStrategy addConnectionStrategy) {
        switch (addConnectionStrategy) {
            case ONLY_IF_EMPTY: {
                if (this.idleConnectionCount.get() != 0) break;
                int n = this.configuration.getMaximumPoolSize();
                int n2 = this.configuration.getAcquireIncrement();
                for (int i = 0; this.idleConnectionCount.get() < n2 && i < n2 && this.totalConnections.get() < n; ++i) {
                    this.addConnection();
                }
                break;
            }
            case MAINTAIN_MINIMUM: {
                int n = this.configuration.getMinimumPoolSize();
                int n3 = this.configuration.getMaximumPoolSize();
                int n4 = this.configuration.getAcquireIncrement();
                for (int i = 0; this.totalConnections.get() < n && i < n4 && this.totalConnections.get() < n3; ++i) {
                    this.addConnection();
                }
                break;
            }
            case BACKGROUND_FILL: {
                if (this.idleConnectionCount.get() != 0 || !this.backgroundFillQueued.compareAndSet(false, true)) break;
                this.houseKeepingTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        int n = HikariPool.this.configuration.getMaximumPoolSize();
                        int n2 = HikariPool.this.configuration.getAcquireIncrement();
                        while ((HikariPool.this.idleConnectionCount.get() < n2 || HikariPool.this.idleConnections.hasWaitingConsumer()) && HikariPool.this.totalConnections.get() < n) {
                            HikariPool.this.addConnection();
                        }
                        HikariPool.this.backgroundFillQueued.set(false);
                    }
                }, 50L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addConnection() {
        int n = 0;
        while (true) {
            try {
                String string;
                Connection connection = this.dataSource.getConnection();
                IHikariConnectionProxy iHikariConnectionProxy = this.delegationProxies ? (IHikariConnectionProxy)JavassistProxyFactoryFactory.getProxyFactory().getProxyConnection(connection) : (IHikariConnectionProxy)connection;
                iHikariConnectionProxy._setParentPool(this);
                boolean bl = this.isConnectionAlive(iHikariConnectionProxy, this.configuration.getConnectionTimeout());
                if (!bl) {
                    throw new RuntimeException("Connection not alive, retry.");
                }
                if (this.transactionIsolation < 0) {
                    this.transactionIsolation = connection.getTransactionIsolation();
                }
                if ((string = this.configuration.getConnectionInitSql()) != null && string.length() > 0) {
                    try (Statement statement = connection.createStatement();){
                        statement.executeQuery(string);
                    }
                }
                this.idleConnectionCount.incrementAndGet();
                this.totalConnections.incrementAndGet();
                this.idleConnections.add(iHikariConnectionProxy);
                return;
            }
            catch (Exception exception) {
                if (n++ > this.configuration.getAcquireRetries()) {
                    LOGGER.error("Maximum connection creation retries exceeded", (Throwable)exception);
                    return;
                }
                try {
                    Thread.sleep(this.configuration.getAcquireRetryDelay());
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isConnectionAlive(Connection connection, long l) {
        if (l < 1000L) {
            l = 1000L;
        }
        try {
            if (this.jdbc4ConnectionTest) {
                return connection.isValid((int)TimeUnit.MILLISECONDS.toSeconds(l));
            }
            try (Statement statement = connection.createStatement();){
                statement.executeQuery(this.configuration.getConnectionTestQuery());
            }
            return true;
        }
        catch (SQLException sQLException) {
            LOGGER.error("Exception during keep alive check.  Connection must be dead.");
            return false;
        }
    }

    private void closeConnection(IHikariConnectionProxy iHikariConnectionProxy) {
        try {
            this.totalConnections.decrementAndGet();
            iHikariConnectionProxy.__close();
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private void rollbackConnection(IHikariConnectionProxy iHikariConnectionProxy) {
        try {
            if (!iHikariConnectionProxy.getAutoCommit()) {
                iHikariConnectionProxy.rollback();
            }
        }
        catch (SQLException sQLException) {
            return;
        }
    }

    private static enum AddConnectionStrategy {
        ONLY_IF_EMPTY,
        BACKGROUND_FILL,
        MAINTAIN_MINIMUM;

    }

    private class HouseKeeper
    extends TimerTask {
        private HouseKeeper() {
        }

        @Override
        public void run() {
            IHikariConnectionProxy iHikariConnectionProxy;
            HikariPool.this.houseKeepingTimer.purge();
            long l = System.currentTimeMillis();
            long l2 = HikariPool.this.configuration.getIdleTimeout();
            long l3 = HikariPool.this.configuration.getMaxLifetime();
            int n = HikariPool.this.idleConnectionCount.get();
            for (int i = 0; i < n && (iHikariConnectionProxy = (IHikariConnectionProxy)HikariPool.this.idleConnections.poll()) != null; ++i) {
                HikariPool.this.idleConnectionCount.decrementAndGet();
                if (l2 > 0L && l > iHikariConnectionProxy._getLastAccess() + l2 || l3 > 0L && l > iHikariConnectionProxy._getCreationTime() + l3) {
                    HikariPool.this.closeConnection(iHikariConnectionProxy);
                    continue;
                }
                HikariPool.this.idleConnectionCount.incrementAndGet();
                HikariPool.this.idleConnections.add(iHikariConnectionProxy);
            }
            HikariPool.this.addConnections(AddConnectionStrategy.MAINTAIN_MINIMUM);
        }
    }
}

