/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariPool;
import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HikariMBeanElf {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariMBeanElf.class);

    private HikariMBeanElf() {
    }

    public static void registerMBeans(HikariConfig hikariConfig, HikariPool hikariPool) {
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName("com.zaxxer.hikari:type=PoolConfig (" + hikariConfig.getPoolName() + ")");
            ObjectName objectName2 = new ObjectName("com.zaxxer.hikari:type=Pool (" + hikariConfig.getPoolName() + ")");
            if (!mBeanServer.isRegistered(objectName)) {
                mBeanServer.registerMBean(hikariConfig, objectName);
                mBeanServer.registerMBean(hikariPool, objectName2);
            } else {
                LOGGER.error("You cannot use the same HikariConfig for separate pool instances.");
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Unable to register management beans.", (Throwable)exception);
        }
    }
}

