/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariPool;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSource
implements DataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariDataSource.class);
    private int loginTimeout;
    private volatile boolean isShutdown;
    HikariPool pool;

    public HikariDataSource(HikariConfig hikariConfig) {
        this.pool = new HikariPool(hikariConfig);
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (!this.isShutdown) {
            return this.pool.getConnection();
        }
        throw new IllegalStateException("The datasource has been shutdown.");
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        LOGGER.warn("getConnection() with username and password is not supported");
        return this.getConnection();
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.pool.dataSource != null ? this.pool.dataSource.getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        if (this.pool.dataSource != null) {
            this.pool.dataSource.setLogWriter(printWriter);
        }
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        this.loginTimeout = n;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.loginTimeout;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return this.getClass().isAssignableFrom(clazz);
    }

    public void shutdown() {
        boolean bl = this.isShutdown;
        this.isShutdown = true;
        if (!bl) {
            this.pool.shutdown();
            this.pool = null;
        }
    }
}

