/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.util;

import com.zaxxer.hikari.util.PoolUtilities;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.AbstractQueuedLongSynchronizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConcurrentBag<T extends BagEntry> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConcurrentBag.class);
    public static final int STATE_NOT_IN_USE = 0;
    public static final int STATE_IN_USE = 1;
    private static final int STATE_REMOVED = -1;
    private static final int STATE_RESERVED = -2;
    private final ThreadLocal<ArrayList<WeakReference<BagEntry>>> threadList;
    private final CopyOnWriteArrayList<T> sharedList = new CopyOnWriteArrayList();
    private final Synchronizer synchronizer = new Synchronizer();
    private final AtomicLong sequence = new AtomicLong(1L);
    private final IBagStateListener listener;

    public ConcurrentBag() {
        this.listener = null;
        this.threadList = new ThreadLocal();
    }

    public ConcurrentBag(IBagStateListener listener) {
        this.listener = listener;
        this.threadList = new ThreadLocal();
    }

    public T borrow(long timeout, TimeUnit timeUnit) throws InterruptedException {
        long startScan;
        ArrayList<WeakReference<BagEntry>> list = this.threadList.get();
        if (list == null) {
            this.threadList.set(new ArrayList(16));
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                BagEntry bagEntry = (BagEntry)list.remove(i).get();
                if (bagEntry == null || !bagEntry.state.compareAndSet(0, 1)) continue;
                return (T)bagEntry;
            }
        }
        timeout = timeUnit.toNanos(timeout);
        do {
            long startSeq;
            startScan = System.nanoTime();
            do {
                startSeq = this.sequence.longValue();
                for (BagEntry bagEntry : this.sharedList) {
                    if (!bagEntry.state.compareAndSet(0, 1)) continue;
                    return (T)bagEntry;
                }
            } while (startSeq < this.sequence.longValue());
            if (this.listener != null) {
                this.listener.addBagItem();
            }
            this.synchronizer.tryAcquireSharedNanos(startSeq, timeout);
        } while ((timeout -= System.nanoTime() - startScan) > 0L);
        return null;
    }

    public void requite(T bagEntry) {
        if (((BagEntry)bagEntry).state.compareAndSet(1, 0)) {
            ArrayList<WeakReference<BagEntry>> list = this.threadList.get();
            if (list != null) {
                list.add(new WeakReference<T>(bagEntry));
            }
        } else {
            throw new IllegalStateException("Value was returned to the bag that was not borrowed: " + bagEntry);
        }
        this.synchronizer.releaseShared(this.sequence.incrementAndGet());
    }

    public void add(T bagEntry) {
        this.sharedList.add(bagEntry);
        this.synchronizer.releaseShared(this.sequence.incrementAndGet());
    }

    public void remove(T bagEntry) {
        if (((BagEntry)bagEntry).state.compareAndSet(1, -1) || ((BagEntry)bagEntry).state.compareAndSet(-2, -1)) {
            if (!this.sharedList.remove(bagEntry)) {
                throw new IllegalStateException("Attempt to remove an object from the bag that does not exist");
            }
        } else {
            throw new IllegalStateException("Attempt to remove an object from the bag that was not borrowed or reserved");
        }
    }

    public List<T> values(int state) {
        ArrayList<BagEntry> list = new ArrayList<BagEntry>(this.sharedList.size());
        if (state == 1 || state == 0) {
            for (BagEntry reference : this.sharedList) {
                if (reference.state.get() != state) continue;
                list.add(reference);
            }
        }
        return list;
    }

    public boolean reserve(T bagEntry) {
        return ((BagEntry)bagEntry).state.compareAndSet(0, -2);
    }

    public void unreserve(T bagEntry) {
        long checkInSeq = this.sequence.incrementAndGet();
        if (!((BagEntry)bagEntry).state.compareAndSet(-2, 0)) {
            throw new IllegalStateException("Attempt to relinquish an object to the bag that was not reserved");
        }
        this.synchronizer.releaseShared(checkInSeq);
    }

    public int getPendingQueue() {
        return this.synchronizer.getQueueLength();
    }

    public int getCount(int state) {
        int count = 0;
        for (BagEntry reference : this.sharedList) {
            if (reference.state.get() != state) continue;
            ++count;
        }
        return count;
    }

    public int size() {
        return this.sharedList.size();
    }

    public void dumpState() {
        for (BagEntry bagEntry : this.sharedList) {
            switch (bagEntry.state.get()) {
                case 1: {
                    LOGGER.info(bagEntry.toString() + " state IN_USE");
                    break;
                }
                case 0: {
                    LOGGER.info(bagEntry.toString() + " state NOT_IN_USE");
                    break;
                }
                case -1: {
                    LOGGER.info(bagEntry.toString() + " state REMOVED");
                    break;
                }
                case -2: {
                    LOGGER.info(bagEntry.toString() + " state RESERVED");
                }
            }
        }
    }

    private static final class Synchronizer
    extends AbstractQueuedLongSynchronizer {
        private static final long serialVersionUID = 104753538004341218L;

        private Synchronizer() {
        }

        @Override
        protected long tryAcquireShared(long seq) {
            return this.getState() > seq && !this.java67hasQueuedPredecessors() ? 1L : -1L;
        }

        @Override
        protected boolean tryReleaseShared(long updateSeq) {
            this.setState(updateSeq);
            return true;
        }

        private boolean java67hasQueuedPredecessors() {
            if (PoolUtilities.IS_JAVA7) {
                return this.hasQueuedPredecessors();
            }
            return false;
        }
    }

    public static interface IBagStateListener {
        public void addBagItem();
    }

    public static abstract class BagEntry {
        final AtomicInteger state = new AtomicInteger();
    }
}

