/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.pool;

import com.zaxxer.hikari.util.ConcurrentBag;
import java.sql.Connection;

public final class PoolBagEntry
extends ConcurrentBag.BagEntry {
    public final Connection connection;
    public final long expirationTime;
    long lastOpenTime;
    long lastAccess;

    PoolBagEntry(Connection connection, long maxLifetime) {
        this.connection = connection;
        this.expirationTime = maxLifetime > 0L ? System.currentTimeMillis() + maxLifetime : Long.MAX_VALUE;
        this.lastAccess = System.currentTimeMillis();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Connection:   ").append(this.connection).append('\n');
        sb.append("Expiration:   ").append(this.expirationTime).append('\n');
        sb.append("Last  access: ").append(this.lastAccess).append('\n');
        sb.append("Last open:    ").append(this.lastOpenTime);
        return sb.toString();
    }
}

