/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.model;

import com.yworks.yshrink.model.AbstractDescriptor;
import com.yworks.yshrink.model.Invocation;
import com.yworks.yshrink.model.InvocationFactory;
import com.yworks.yshrink.util.Util;
import java.io.File;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.Type;

public class MethodDescriptor
extends AbstractDescriptor {
    private String name;
    private String desc;
    private List<Invocation> invocations;
    private List<String[]> fieldRefs;
    private List<AbstractMap.SimpleEntry<Object, Object>> typeInstructions;
    private String[] exceptions;
    private List<String> localVars;

    protected MethodDescriptor(String name, int access, String desc, String[] exceptions, File sourceJar) {
        super(access, sourceJar);
        this.name = name;
        this.desc = desc;
        this.invocations = new ArrayList<Invocation>();
        this.fieldRefs = new ArrayList<String[]>();
        this.typeInstructions = new ArrayList<AbstractMap.SimpleEntry<Object, Object>>();
        this.localVars = new ArrayList<String>();
        this.exceptions = exceptions;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Type[] getArgumentTypes() {
        return Type.getArgumentTypes((String)this.desc);
    }

    public String getArgumentsString() {
        Type[] argumentTypes;
        StringBuilder buf = new StringBuilder();
        for (Type type : argumentTypes = this.getArgumentTypes()) {
            buf.append(type.getDescriptor());
        }
        return buf.toString();
    }

    public Type getReturnType() {
        return Type.getReturnType((String)this.desc);
    }

    public List<Invocation> getInvocations() {
        return this.invocations;
    }

    public void addInvocation(int opcode, String type, String name, String desc) {
        this.invocations.add(InvocationFactory.getInstance().getInvocation(opcode, type, name, desc));
    }

    public List<String[]> getFieldRefs() {
        return this.fieldRefs;
    }

    public void addFieldRef(String type, String name) {
        this.fieldRefs.add(new String[]{type, name});
    }

    public void addTypeInstruction(int opcode, String desc) {
        this.typeInstructions.add(new AbstractMap.SimpleEntry<Integer, String>(opcode, desc));
    }

    public void addLocalVar(String desc) {
        this.localVars.add(desc);
    }

    public List<AbstractMap.SimpleEntry<Object, Object>> getTypeInstructions() {
        return this.typeInstructions;
    }

    public String[] getExceptions() {
        return this.exceptions;
    }

    public boolean hasFlag(int code) {
        return (this.access & code) == code;
    }

    public boolean isStatic() {
        return (this.access & 8) == 8;
    }

    public boolean isPrivate() {
        return (this.access & 2) == 2;
    }

    @Override
    public int getAccess() {
        return this.access;
    }

    public boolean overrides(MethodDescriptor md) {
        return this.overrides(md.getName(), md.getReturnType(), md.getArgumentTypes());
    }

    public boolean overrides(Method m) {
        return this.overrides(m.getName(), Type.getReturnType((Method)m), Type.getArgumentTypes((Method)m));
    }

    private boolean overrides(String mName, Type mReturnType, Type[] mArgumentTypes) {
        Type[] argumentTypesMd;
        if (!mName.equals(this.getName())) {
            return false;
        }
        if (!this.getReturnType().equals((Object)mReturnType)) {
            return false;
        }
        Type[] argumentTypes = this.getArgumentTypes();
        if (argumentTypes.length != (argumentTypesMd = mArgumentTypes).length) {
            return false;
        }
        for (int i = 0; i < argumentTypes.length; ++i) {
            if (argumentTypes[i].equals((Object)argumentTypesMd[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "MethodDescriptor{name='" + this.name + '\'' + ", desc='" + this.desc + '\'' + '}';
    }

    public boolean isConstructor() {
        return this.getName().equals("<init>");
    }

    public String getSignature() {
        StringBuilder buf = new StringBuilder();
        buf.append(Util.toJavaType(this.getReturnType().getDescriptor())).append(" ").append(this.getName()).append("(");
        Type[] argumentTypes = this.getArgumentTypes();
        for (int i = 0; i < argumentTypes.length - 1; ++i) {
            Type type = argumentTypes[i];
            buf.append(Util.toJavaType(type.getDescriptor())).append(",");
        }
        if (argumentTypes.length > 0) {
            buf.append(Util.toJavaType(argumentTypes[argumentTypes.length - 1].getDescriptor()));
        }
        buf.append(")");
        return buf.toString();
    }
}

