/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.RecordComponent;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RecordAttrInfo
extends AttrInfo {
    private static final int COMPONENTS_COUNT_FIELD_SIZE = 2;
    private RecordComponent[] components = new RecordComponent[0];
    private boolean attrInfoLengthDirty;

    RecordAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "Record";
    }

    RecordComponent[] getComponents() {
        return this.components;
    }

    @Override
    protected int getAttrInfoLength() {
        if (this.attrInfoLengthDirty) {
            int newAttrLength = 2;
            int m = this.components.length;
            for (int i = 0; i < m; ++i) {
                newAttrLength += RecordAttrInfo.componentLength(this.components[i]);
            }
            this.u4attrLength = newAttrLength;
            this.attrInfoLengthDirty = false;
        }
        return this.u4attrLength;
    }

    @Override
    protected void trimAttrsExcept(String[] keepAttrs) {
        boolean dirty = false;
        int n = this.components.length;
        for (int i = 0; i < n; ++i) {
            dirty |= this.components[i].trimAttrsExcept(keepAttrs);
        }
        this.attrInfoLengthDirty = dirty;
    }

    @Override
    protected void markUtf8RefsInInfo(ConstantPool pool) {
        int n = this.components.length;
        for (int i = 0; i < n; ++i) {
            this.components[i].markUtf8Refs(pool);
        }
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        int u2ComponentsCount = din.readUnsignedShort();
        this.components = new RecordComponent[u2ComponentsCount];
        for (int i = 0; i < u2ComponentsCount; ++i) {
            this.components[i] = RecordComponent.read(din, this.owner);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        int u2ComponentsCount = this.components.length;
        dout.writeShort(u2ComponentsCount);
        for (int i = 0; i < u2ComponentsCount; ++i) {
            this.components[i].write(dout);
        }
    }

    private static int componentLength(RecordComponent c) {
        int length = 6;
        AttrInfo[] attributes = c.getAttributes();
        int n = attributes.length;
        for (int j = 0; j < n; ++j) {
            length += 6;
            length += attributes[j].getAttrInfoLength();
        }
        return length;
    }
}

