/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.ant.filters;

import com.yworks.common.ant.TypePatternSet;
import com.yworks.yshrink.ant.MethodSection;
import com.yworks.yshrink.ant.filters.PatternMatchedFilter;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.Project;
import org.objectweb.asm.Type;

public class MethodFilter
extends PatternMatchedFilter {
    private List<MethodSection> sections;

    public MethodFilter(Project project) {
        super(project);
    }

    public void addMethodSection(MethodSection methodSection) {
        if (null == this.sections) {
            this.sections = new ArrayList<MethodSection>(5);
        }
        this.sections.add(methodSection);
    }

    @Override
    public boolean isEntryPointMethod(Model model, ClassDescriptor cd, MethodDescriptor md) {
        String className = cd.getName();
        String methodName = md.getName();
        for (MethodSection ms : this.sections) {
            String entryMethodName = ms.getName();
            String entryMethodClass = ms.getClassName();
            boolean r = true;
            if (null != ms.getReturnType()) {
                Type requiredReturnType = Type.getType((String)Util.verboseToNativeType(ms.getReturnType()));
                r &= requiredReturnType.equals((Object)md.getReturnType());
            }
            if (null != ms.getArgs()) {
                Type[] argTypes;
                String[] requiredArgTypes = ms.getArgs().split("\\s*,\\s*");
                if (requiredArgTypes.length == 1 && requiredArgTypes[0].length() == 0) {
                    requiredArgTypes = new String[]{};
                }
                if (requiredArgTypes.length == (argTypes = md.getArgumentTypes()).length) {
                    for (int i = 0; i < argTypes.length; ++i) {
                        Type argType = argTypes[i];
                        Type requiredArgType = Type.getType((String)Util.verboseToNativeType(requiredArgTypes[i].trim()));
                        r &= argType.equals((Object)requiredArgType);
                    }
                } else {
                    r = false;
                }
            }
            if (null != ms.getAccess()) {
                r &= ms.getAccess().isAccessLevel(md.getAccess());
            }
            r = null == entryMethodClass || entryMethodClass.length() == 0 ? (r &= this.match(TypePatternSet.Type.CLASS, className, ms) || this.match(TypePatternSet.Type.CLASS, Util.toJavaClass(className), ms)) : (r &= entryMethodClass.equals(className));
            if (null != ms.getThrows()) {
                StringTokenizer tokenizer = new StringTokenizer(ms.getThrows(), ",");
                while (tokenizer.hasMoreTokens()) {
                    String exception = Util.toInternalClass(tokenizer.nextToken().trim());
                    boolean found = false;
                    if (null != md.getExceptions()) {
                        for (String exception2 : md.getExceptions()) {
                            if (!exception2.equals(exception)) continue;
                            found = true;
                        }
                    }
                    r &= found;
                }
            }
            r = null == entryMethodName || entryMethodName.length() == 0 ? (r &= this.match(TypePatternSet.Type.NAME, methodName, ms)) : (r &= entryMethodName.equals(methodName));
            if (!r) continue;
            return r;
        }
        return false;
    }
}

