/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.LineNumberInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class LineNumberTableAttrInfo
extends AttrInfo {
    private int u2lineNumberTableLength;
    private LineNumberInfo[] lineNumberTable;

    protected LineNumberTableAttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        super(cf, attrNameIndex, attrLength);
    }

    @Override
    protected String getAttrName() {
        return "LineNumberTable";
    }

    public LineNumberInfo[] getLineNumberTable() {
        return this.lineNumberTable;
    }

    public void setLineNumberTable(LineNumberInfo[] table) {
        this.lineNumberTable = table;
        this.u2lineNumberTableLength = this.lineNumberTable.length;
        this.u4attrLength = 2 + 4 * this.u2lineNumberTableLength;
    }

    @Override
    protected void readInfo(DataInput din) throws IOException {
        this.u2lineNumberTableLength = din.readUnsignedShort();
        this.lineNumberTable = new LineNumberInfo[this.u2lineNumberTableLength];
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            this.lineNumberTable[i] = LineNumberInfo.create(din);
        }
    }

    @Override
    public void writeInfo(DataOutput dout) throws IOException {
        dout.writeShort(this.u2lineNumberTableLength);
        for (int i = 0; i < this.u2lineNumberTableLength; ++i) {
            this.lineNumberTable[i].write(dout);
        }
    }
}

