/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.ElementValuePairInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AnnotationInfo {
    protected int u2typeIndex;
    private ElementValuePairInfo[] elementValuePairs;

    public static AnnotationInfo create(DataInput din) throws IOException {
        AnnotationInfo an = new AnnotationInfo();
        an.read(din);
        return an;
    }

    AnnotationInfo() {
    }

    public ElementValuePairInfo[] getElementValuePairs() {
        return this.elementValuePairs;
    }

    protected void markUtf8RefsInInfo(ConstantPool pool) {
        pool.getCpEntry(this.u2typeIndex).incRefCount();
        int u2elementCount = this.elementValuePairs.length;
        for (int i = 0; i < u2elementCount; ++i) {
            this.elementValuePairs[i].markUtf8RefsInInfo(pool);
        }
    }

    void read(DataInput din) throws IOException {
        this.u2typeIndex = din.readUnsignedShort();
        int u2elementCount = din.readUnsignedShort();
        this.elementValuePairs = new ElementValuePairInfo[u2elementCount];
        for (int i = 0; i < u2elementCount; ++i) {
            this.elementValuePairs[i] = ElementValuePairInfo.create(din);
        }
    }

    public void write(DataOutput dout) throws IOException {
        dout.writeShort(this.u2typeIndex);
        int u2elementCount = this.elementValuePairs.length;
        dout.writeShort(u2elementCount);
        for (int i = 0; i < u2elementCount; ++i) {
            this.elementValuePairs[i].write(dout);
        }
    }
}

