/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf;

import com.yworks.yguard.obf.LineNumberTableMapper;
import java.io.PrintWriter;

public class YGuardRule {
    public static final int PUBLIC = 1;
    public static final int PROTECTED = 4;
    public static final int FRIENDLY = 4096;
    public static final int PRIVATE = 2;
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_PUBLIC = 1;
    public static final int LEVEL_PROTECTED = 5;
    public static final int LEVEL_FRIENDLY = 4101;
    public static final int LEVEL_PRIVATE = 4103;
    public static final int TYPE_ATTR = 0;
    public static final int TYPE_CLASS = 1;
    public static final int TYPE_FIELD = 2;
    public static final int TYPE_METHOD = 3;
    public static final int TYPE_PACKAGE_MAP = 4;
    public static final int TYPE_CLASS_MAP = 5;
    public static final int TYPE_FIELD_MAP = 6;
    public static final int TYPE_METHOD_MAP = 7;
    public static final int TYPE_SOURCE_ATTRIBUTE_MAP = 8;
    public static final int TYPE_LINE_NUMBER_MAPPER = 9;
    public static final int TYPE_ATTR2 = 10;
    public static final int TYPE_PACKAGE = 11;
    public int type;
    public String name;
    public String descriptor;
    public String obfName;
    public LineNumberTableMapper lineNumberTableMapper;
    public int retainFields = 0;
    public int retainMethods = 0;
    public int retainClasses = 4103;

    public YGuardRule(int type, String name) {
        this.type = type;
        this.name = name;
        this.descriptor = null;
        this.obfName = null;
        this.lineNumberTableMapper = null;
    }

    public YGuardRule(int type, String name, String descriptor) {
        this.obfName = null;
        this.type = type;
        this.name = name;
        this.descriptor = descriptor;
        this.lineNumberTableMapper = null;
    }

    public YGuardRule(String className, LineNumberTableMapper lineNumberTableMapper) {
        this.descriptor = null;
        this.obfName = null;
        this.name = className;
        this.type = 9;
        this.lineNumberTableMapper = lineNumberTableMapper;
    }

    public void logProperties(PrintWriter pw) {
        if (this.type == 9) {
            this.lineNumberTableMapper.logProperties(pw);
        }
    }

    public String toString() {
        return YGuardRule.typeToString(this.type) + " " + this.name + " " + this.descriptor + " fields: " + YGuardRule.methodToString(this.retainFields) + " methods: " + YGuardRule.methodToString(this.retainMethods) + " classes: " + YGuardRule.methodToString(this.retainClasses);
    }

    public static String typeToString(int type) {
        switch (type) {
            default: {
                return "Unknown type " + type;
            }
            case 0: {
                return "ATTRIBUTE";
            }
            case 10: {
                return "ATTRIBUTE PER CLASS";
            }
            case 1: {
                return "CLASS";
            }
            case 5: {
                return "CLASS_MAP";
            }
            case 2: {
                return "FIELD";
            }
            case 6: {
                return "FIELD_MAP";
            }
            case 3: {
                return "METHOD";
            }
            case 7: {
                return "METHOD_MAP";
            }
            case 4: {
                return "PACKAGE_MAP";
            }
            case 8: {
                return "SOURCE_ATTRIBUTE_MAP";
            }
            case 9: {
                return "LINE_NUMBER_MAPPER";
            }
            case 11: 
        }
        return "PACKAGE";
    }

    public static String methodToString(int modifier) {
        switch (modifier) {
            default: {
                return "Unknown modifier " + modifier;
            }
            case 0: {
                return "LEVEL_NONE";
            }
            case 4101: {
                return "LEVEL_FRIENDLY";
            }
            case 4103: {
                return "LEVEL_PRIVATE";
            }
            case 5: {
                return "LEVEL_PROTECTED";
            }
            case 1: 
        }
        return "LEVEL_PUBLIC";
    }
}

