/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard;

import com.yworks.yguard.obf.ClassTree;

public class Conversion {
    protected Conversion() {
    }

    public static String toJavaClass(String className) {
        if (className.endsWith(".class")) {
            className = className.substring(0, className.length() - 6);
        }
        return className.replace('/', '.');
    }

    public static String toJavaType(String type) {
        StringBuffer nat = new StringBuffer(30);
        int arraydim = 0;
        while (type.charAt(arraydim) == '[') {
            ++arraydim;
        }
        type = type.substring(arraydim);
        switch (type.charAt(0)) {
            default: {
                throw new IllegalArgumentException("unknown native type:" + type);
            }
            case 'B': {
                nat.append("byte");
                break;
            }
            case 'C': {
                nat.append("char");
                break;
            }
            case 'D': {
                nat.append("double");
                break;
            }
            case 'F': {
                nat.append("float");
                break;
            }
            case 'I': {
                nat.append("int");
                break;
            }
            case 'J': {
                nat.append("long");
                break;
            }
            case 'S': {
                nat.append("short");
                break;
            }
            case 'Z': {
                nat.append("boolean");
                break;
            }
            case 'V': {
                nat.append("void");
                break;
            }
            case 'L': {
                String className = type.substring(1, type.length() - 1);
                if (className.indexOf(60) >= 0) {
                    String parameters = type.substring(className.indexOf(60) + 2, className.lastIndexOf(62) - 1);
                    className = className.substring(0, className.indexOf(60));
                    nat.append(className.replace('/', '.'));
                    nat.append('<');
                    nat.append(Conversion.toJavaParameters(parameters));
                    nat.append('>');
                    break;
                }
                nat.append(className.replace('/', '.'));
            }
        }
        for (int i = 0; i < arraydim; ++i) {
            nat.append("[]");
        }
        return nat.toString();
    }

    public static String mapSignature(String signature) {
        return new ClassTree().mapSignature(signature);
    }

    public static String toJavaParameters(String parameters) {
        StringBuffer nat = new StringBuffer(30);
        switch (parameters.charAt(0)) {
            default: {
                throw new IllegalArgumentException("unknown native type:" + parameters.charAt(0));
            }
            case '+': {
                nat.append("? extends ").append(Conversion.toJavaParameters(parameters.substring(1)));
                break;
            }
            case '-': {
                nat.append("? super ").append(Conversion.toJavaParameters(parameters.substring(1)));
                break;
            }
            case '*': {
                nat.append("*");
                if (parameters.length() <= 1) break;
                nat.append(", ").append(Conversion.toJavaParameters(parameters.substring(1)));
                break;
            }
            case 'B': {
                nat.append("byte");
                break;
            }
            case 'C': {
                nat.append("char");
                break;
            }
            case 'D': {
                nat.append("double");
                break;
            }
            case 'F': {
                nat.append("float");
                break;
            }
            case 'I': {
                nat.append("int");
                break;
            }
            case 'J': {
                nat.append("long");
                break;
            }
            case 'S': {
                nat.append("short");
                break;
            }
            case 'Z': {
                nat.append("boolean");
                break;
            }
            case 'V': {
                nat.append("void");
                break;
            }
            case 'L': {
                int len = parameters.indexOf(60);
                if (len < 0) break;
                len = Math.min(len, parameters.indexOf(59));
                break;
            }
            case 'T': {
                int index = parameters.indexOf(59);
                nat.append(parameters.substring(1, index));
                if (parameters.length() <= index) break;
                nat.append(", ");
                nat.append(parameters.substring(index));
            }
        }
        return nat.toString();
    }

    public static String toJavaMethod(String name, String signature) {
        String argsonly = signature.substring(signature.indexOf(40) + 1);
        String ret = signature.substring(signature.indexOf(41) + 1);
        ret = Conversion.toJavaType(ret);
        StringBuffer args = new StringBuffer();
        args.append('(');
        if (argsonly.indexOf(41) > 0) {
            argsonly = argsonly.substring(0, argsonly.indexOf(41));
            Conversion.toJavaArguments(argsonly, args);
        }
        args.append(')');
        return ret + " " + name + args.toString();
    }

    public static String toJavaArguments(String args) {
        StringBuffer b = new StringBuffer(args.length() + 32);
        Conversion.toJavaArguments(args, b);
        return b.toString();
    }

    private static void toJavaArguments(String argsonly, StringBuffer args) {
        int argcount = 0;
        int pos = 0;
        StringBuffer arg = new StringBuffer(20);
        while (pos < argsonly.length()) {
            while (argsonly.charAt(pos) == '[') {
                arg.append('[');
                ++pos;
            }
            if (argsonly.charAt(pos) == 'L') {
                while (argsonly.charAt(pos) != ';') {
                    arg.append(argsonly.charAt(pos));
                    ++pos;
                }
                arg.append(';');
                if (argcount > 0) {
                    args.append(',');
                    args.append(' ');
                }
                args.append(Conversion.toJavaType(arg.toString()));
                ++argcount;
                arg.setLength(0);
                ++pos;
                continue;
            }
            arg.append(argsonly.charAt(pos));
            if (argcount > 0) {
                args.append(',');
                args.append(' ');
            }
            args.append(Conversion.toJavaType(arg.toString()));
            ++argcount;
            arg.setLength(0);
            ++pos;
        }
    }
}

