/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yshrink.core;

import com.yworks.util.graph.Network;
import com.yworks.yshrink.core.Dfs;
import com.yworks.yshrink.model.AbstractDescriptor;
import com.yworks.yshrink.model.ClassDescriptor;
import com.yworks.yshrink.model.EdgeType;
import com.yworks.yshrink.model.MethodDescriptor;
import com.yworks.yshrink.model.Model;
import com.yworks.yshrink.model.NodeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Shrinker {
    public void shrink(Model model) {
        ShrinkDfs shrinkDfs = new ShrinkDfs(model);
        shrinkDfs.setDirectedMode(true);
        Iterator nodeIterator = model.getNetwork().nodes();
        while (nodeIterator.hasNext()) {
            Object node = nodeIterator.next();
            model.markObsolete(node);
        }
        shrinkDfs.init(model.getEntryPointNode());
        int numInstantiated = -1;
        while (shrinkDfs.numInstantiated > numInstantiated) {
            numInstantiated = shrinkDfs.numInstantiated;
            shrinkDfs.nextRound();
        }
        shrinkDfs.markReachableNodes();
    }

    private class ShrinkDfs
    extends Dfs {
        private Model model;
        private Network network;
        private Object entryPointNode;
        private Map<Object, Object> instanceMap;
        private int numInstantiated = 0;
        private int round = 0;
        private int numSkipped = 0;
        private static final int EXPLORE_MODE = 0;
        private static final int RESULT_MODE = 1;
        private int mode = 0;

        ShrinkDfs(Model model) {
            this.model = model;
            this.network = model.getNetwork();
        }

        public void init(Object entryPointNode) {
            this.entryPointNode = entryPointNode;
            this.round = 0;
            if (this.instanceMap == null) {
                this.instanceMap = new HashMap<Object, Object>();
            }
            Iterator nodeIterator = this.network.nodes();
            while (nodeIterator.hasNext()) {
                Object n = nodeIterator.next();
                this.instanceMap.put(n, -1);
            }
        }

        protected int nextRound() {
            ++this.round;
            this.numSkipped = 0;
            this.numInstantiated = 0;
            super.start(this.network, this.entryPointNode);
            return this.numInstantiated;
        }

        @Override
        protected void postVisit(Object node, int i, int j) {
            if (this.mode == 0 && NodeType.isNewNode(this.model.getNodeType(node))) {
                Object classNode = this.model.getClassNode(node);
                this.instanceMap.put(classNode, this.round);
                ++this.numInstantiated;
            }
        }

        @Override
        protected void preVisit(Object node, int dfsNumber) {
            if (this.mode == 1) {
                this.model.markNotObsolete(node);
            }
        }

        protected void markReachableNodes() {
            int oldMode = this.mode;
            this.mode = 1;
            super.start(this.network, this.entryPointNode);
            this.mode = oldMode;
        }

        @Override
        protected boolean doTraverse(Object edge) {
            boolean allowed = false;
            Object target = this.network.getTarget(edge);
            if (!NodeType.isMethodNode(this.model.getNodeType(target))) {
                allowed = true;
            } else if (!this.model.getDependencyType(edge).equals((Object)EdgeType.RESOLVE) && !this.model.getDependencyType(edge).equals((Object)EdgeType.ENCLOSE)) {
                AbstractDescriptor targetDescriptor = this.model.getDescriptor(target);
                MethodDescriptor targetMethod = (MethodDescriptor)targetDescriptor;
                Object classNode = this.model.getClassNode(target);
                ClassDescriptor targetClass = (ClassDescriptor)this.model.getDescriptor(classNode);
                allowed = allowed || targetMethod.isStatic();
                allowed = allowed || targetMethod.hasFlag(1) && !targetMethod.hasFlag(1024);
                allowed = allowed || targetClass.isAnnotation();
                allowed = allowed || this.model.getDependencyType(edge).equals((Object)EdgeType.SUPER);
                allowed = allowed || NodeType.isNewNode(this.model.getNodeType(target));
                allowed = allowed || "<init>".equals(targetMethod.getName());
                allowed = allowed || targetMethod.isPrivate();
                allowed = allowed || this.wasClassInstantiated(edge);
                allowed = allowed || this.isMethodNeeded(targetClass, targetMethod);
                allowed = allowed || this.model.getDependencyType(edge).equals((Object)EdgeType.INVOKEDYNAMIC);
            } else if (this.mode == 1) {
                this.model.markStubNeeded(target);
            }
            return allowed;
        }

        private boolean isMethodNeeded(ClassDescriptor cd, MethodDescriptor md) {
            ArrayList<ClassDescriptor> descendants = new ArrayList<ClassDescriptor>(5);
            this.model.getInternalDescendants(cd, descendants);
            for (ClassDescriptor descendant : descendants) {
                if (descendant.implementsMethod(md.getName(), md.getDesc()) || (Integer)this.instanceMap.get(descendant.getNode()) < this.round - 1) continue;
                return true;
            }
            return false;
        }

        private boolean wasClassInstantiated(Object edge) {
            Object targetNode = this.network.getTarget(edge);
            Object classNode = this.model.getClassNode(targetNode);
            if ((Integer)this.instanceMap.get(classNode) >= this.round - 1) {
                return true;
            }
            ++this.numSkipped;
            return false;
        }

        protected int getNumSkipped() {
            return this.numSkipped;
        }
    }
}

