/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.obf.ObfuscationConfig;
import com.yworks.yguard.obf.Tools;
import com.yworks.yguard.obf.classfile.AnnotationInfo;
import com.yworks.yguard.obf.classfile.AttrInfo;
import com.yworks.yguard.obf.classfile.ClassConstants;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.ElementValuePairInfo;
import com.yworks.yguard.obf.classfile.Logger;
import com.yworks.yguard.obf.classfile.RuntimeVisibleAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.Utf8CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class ClassItemInfo
implements ClassConstants {
    private int u2accessFlags;
    private int u2nameIndex;
    private int u2descriptorIndex;
    protected int u2attributesCount;
    protected AttrInfo[] attributes;
    private ClassFile cf;
    private boolean isSynthetic = false;
    private static final ObfuscationConfig DUMMY = new ObfuscationConfig(true, true);
    private ObfuscationConfig obfuscationConfig = DUMMY;

    protected ClassItemInfo(ClassFile cf) {
        this.cf = cf;
    }

    public static ObfuscationConfig getObfuscationConfig(String name, AttrInfo[] attributes) {
        if (attributes == null) {
            return null;
        }
        for (int i = 0; i < attributes.length; ++i) {
            AttrInfo attribute = attributes[i];
            if (!(attribute instanceof RuntimeVisibleAnnotationsAttrInfo)) continue;
            RuntimeVisibleAnnotationsAttrInfo annotation = (RuntimeVisibleAnnotationsAttrInfo)attribute;
            ClassFile owner = annotation.getOwner();
            AnnotationInfo[] clAnnotations = annotation.getAnnotations();
            for (int j = 0; j < clAnnotations.length; ++j) {
                Utf8CpInfo cpEntry = (Utf8CpInfo)owner.getCpEntry(annotation.getU2TypeIndex(j));
                String currentAnnotationName = cpEntry.getString();
                if (currentAnnotationName == null || !currentAnnotationName.contains(ObfuscationConfig.annotationClassName)) continue;
                AnnotationInfo clAnnotation = clAnnotations[j];
                boolean exclude = ClassItemInfo.getExclude(clAnnotation, owner);
                boolean applyToMembers = ClassItemInfo.getApplyToMembers(clAnnotation, owner);
                Logger.getInstance().log(String.format("Applied annotation %s to %s", ObfuscationConfig.annotationClassName, name));
                return new ObfuscationConfig(exclude, applyToMembers);
            }
        }
        return null;
    }

    private static boolean getExclude(AnnotationInfo clAnnotation, ClassFile owner) {
        ElementValuePairInfo[] elementValuePairs = clAnnotation.getElementValuePairs();
        for (int i = 0; i < elementValuePairs.length; ++i) {
            ElementValuePairInfo elementValuePair = elementValuePairs[i];
            Utf8CpInfo cpEntry = (Utf8CpInfo)owner.getCpEntry(elementValuePair.getU2ElementNameIndex());
            if (!"exclude".equals(cpEntry.getString())) continue;
            return elementValuePair.getElementValue().getBoolValue(owner.getConstantPool());
        }
        return true;
    }

    private static boolean getApplyToMembers(AnnotationInfo clAnnotation, ClassFile owner) {
        ElementValuePairInfo[] elementValuePairs = clAnnotation.getElementValuePairs();
        for (int i = 0; i < elementValuePairs.length; ++i) {
            ElementValuePairInfo elementValuePair = elementValuePairs[i];
            Utf8CpInfo cpEntry = (Utf8CpInfo)owner.getCpEntry(elementValuePair.getU2ElementNameIndex());
            if (!"applyToMembers".equals(cpEntry.getString())) continue;
            return elementValuePair.getElementValue().getBoolValue(owner.getConstantPool());
        }
        return true;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    protected int getNameIndex() {
        return this.u2nameIndex;
    }

    protected void setNameIndex(int index) {
        this.u2nameIndex = index;
    }

    protected int getDescriptorIndex() {
        return this.u2descriptorIndex;
    }

    protected void setDescriptorIndex(int index) {
        this.u2descriptorIndex = index;
    }

    public String getName() {
        return ((Utf8CpInfo)this.cf.getCpEntry(this.u2nameIndex)).getString();
    }

    public String getDescriptor() {
        return ((Utf8CpInfo)this.cf.getCpEntry(this.u2descriptorIndex)).getString();
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    protected void trimAttrsExcept(String[] keepAttrs) {
        for (int i = 0; i < this.attributes.length; ++i) {
            if (Tools.isInArray(this.attributes[i].getAttrName(), keepAttrs)) {
                this.attributes[i].trimAttrsExcept(keepAttrs);
                continue;
            }
            this.attributes[i] = null;
        }
        AttrInfo[] left = new AttrInfo[this.attributes.length];
        int j = 0;
        for (int i = 0; i < this.attributes.length; ++i) {
            if (this.attributes[i] == null) continue;
            left[j++] = this.attributes[i];
        }
        this.attributes = new AttrInfo[j];
        System.arraycopy(left, 0, this.attributes, 0, j);
        this.u2attributesCount = j;
    }

    protected void markUtf8Refs(ConstantPool pool) {
        pool.incRefCount(this.u2nameIndex);
        pool.incRefCount(this.u2descriptorIndex);
        for (int i = 0; i < this.attributes.length; ++i) {
            this.attributes[i].markUtf8Refs(pool);
        }
    }

    protected void read(DataInput din) throws IOException {
        this.u2accessFlags = din.readUnsignedShort();
        this.u2nameIndex = din.readUnsignedShort();
        this.u2descriptorIndex = din.readUnsignedShort();
        this.u2attributesCount = din.readUnsignedShort();
        this.attributes = new AttrInfo[this.u2attributesCount];
        for (int i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i] = AttrInfo.create(din, this.cf);
            if (!this.attributes[i].getAttrName().equals("Synthetic")) continue;
            this.isSynthetic = true;
        }
    }

    public void write(DataOutput dout) throws IOException {
        if (dout == null) {
            throw new NullPointerException("No output stream was provided.");
        }
        dout.writeShort(this.u2accessFlags);
        dout.writeShort(this.u2nameIndex);
        dout.writeShort(this.u2descriptorIndex);
        dout.writeShort(this.u2attributesCount);
        for (int i = 0; i < this.u2attributesCount; ++i) {
            this.attributes[i].write(dout);
        }
    }

    public ObfuscationConfig getObfuscationConfig() {
        if (this.obfuscationConfig == DUMMY) {
            this.obfuscationConfig = ClassItemInfo.getObfuscationConfig(String.format("%s#%s", this.cf.getName(), this.getName()), this.attributes);
        }
        return this.obfuscationConfig;
    }
}

