/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.yguard.obf.classfile;

import com.yworks.yguard.Conversion;
import com.yworks.yguard.ParseException;
import com.yworks.yguard.obf.classfile.AnnotationDefaultAttrInfo;
import com.yworks.yguard.obf.classfile.BootstrapMethodsAttrInfo;
import com.yworks.yguard.obf.classfile.ClassConstants;
import com.yworks.yguard.obf.classfile.ClassFile;
import com.yworks.yguard.obf.classfile.CodeAttrInfo;
import com.yworks.yguard.obf.classfile.ConstantPool;
import com.yworks.yguard.obf.classfile.ConstantValueAttrInfo;
import com.yworks.yguard.obf.classfile.CpInfo;
import com.yworks.yguard.obf.classfile.DeprecatedAttrInfo;
import com.yworks.yguard.obf.classfile.EnclosingMethodAttrInfo;
import com.yworks.yguard.obf.classfile.ExceptionsAttrInfo;
import com.yworks.yguard.obf.classfile.InnerClassesAttrInfo;
import com.yworks.yguard.obf.classfile.LineNumberTableAttrInfo;
import com.yworks.yguard.obf.classfile.LocalVariableTableAttrInfo;
import com.yworks.yguard.obf.classfile.LocalVariableTypeTableAttrInfo;
import com.yworks.yguard.obf.classfile.Logger;
import com.yworks.yguard.obf.classfile.MethodParametersAttrInfo;
import com.yworks.yguard.obf.classfile.ModuleAttrInfo;
import com.yworks.yguard.obf.classfile.ModuleMainClassAttrInfo;
import com.yworks.yguard.obf.classfile.ModulePackagesAttrInfo;
import com.yworks.yguard.obf.classfile.NestHostAttrInfo;
import com.yworks.yguard.obf.classfile.NestMembersAttrInfo;
import com.yworks.yguard.obf.classfile.RuntimeInvisibleAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.RuntimeInvisibleParameterAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.RuntimeInvisibleTypeAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.RuntimeVisibleAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.RuntimeVisibleParameterAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.RuntimeVisibleTypeAnnotationsAttrInfo;
import com.yworks.yguard.obf.classfile.SignatureAttrInfo;
import com.yworks.yguard.obf.classfile.SourceFileAttrInfo;
import com.yworks.yguard.obf.classfile.StackMapTableAttrInfo;
import com.yworks.yguard.obf.classfile.SyntheticAttrInfo;
import com.yworks.yguard.obf.classfile.Utf8CpInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class AttrInfo
implements ClassConstants {
    public static final int CONSTANT_FIELD_SIZE = 6;
    private int u2attrNameIndex;
    protected int u4attrLength;
    private byte[] info;
    protected ClassFile owner;

    public static AttrInfo create(DataInput din, ClassFile cf) throws IOException {
        if (din == null) {
            throw new NullPointerException("No input stream was provided.");
        }
        AttrInfo ai = null;
        int attrNameIndex = din.readUnsignedShort();
        int attrLength = din.readInt();
        CpInfo cpInfo = cf.getCpEntry(attrNameIndex);
        if (cpInfo instanceof Utf8CpInfo) {
            String attrName = ((Utf8CpInfo)cpInfo).getString();
            if (attrName.equals("Code")) {
                ai = new CodeAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("ConstantValue")) {
                ai = new ConstantValueAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("Exceptions")) {
                ai = new ExceptionsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("StackMapTable")) {
                ai = new StackMapTableAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("LineNumberTable")) {
                ai = new LineNumberTableAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("SourceFile")) {
                ai = new SourceFileAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("LocalVariableTable")) {
                ai = new LocalVariableTableAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("InnerClasses")) {
                ai = new InnerClassesAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("Synthetic")) {
                ai = new SyntheticAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("Deprecated")) {
                ai = new DeprecatedAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("Signature")) {
                ai = new SignatureAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("LocalVariableTypeTable")) {
                ai = new LocalVariableTypeTableAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("EnclosingMethod")) {
                ai = new EnclosingMethodAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("RuntimeVisibleAnnotations")) {
                ai = new RuntimeVisibleAnnotationsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("RuntimeVisibleTypeAnnotations")) {
                ai = new RuntimeVisibleTypeAnnotationsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("RuntimeInvisibleAnnotations")) {
                ai = new RuntimeInvisibleAnnotationsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("RuntimeInvisibleTypeAnnotations")) {
                ai = new RuntimeInvisibleTypeAnnotationsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("RuntimeVisibleParameterAnnotations")) {
                ai = new RuntimeVisibleParameterAnnotationsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("RuntimeInvisibleParameterAnnotations")) {
                ai = new RuntimeInvisibleParameterAnnotationsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("AnnotationDefault")) {
                ai = new AnnotationDefaultAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("BootstrapMethods")) {
                ai = new BootstrapMethodsAttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("Bridge") && attrLength == 0) {
                ai = new AttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("Enum") && attrLength == 0) {
                ai = new AttrInfo(cf, attrNameIndex, attrLength);
            } else if (attrName.equals("Varargs") && attrLength == 0) {
                ai = new AttrInfo(cf, attrNameIndex, attrLength);
            } else if ("MethodParameters".equals(attrName)) {
                ai = new MethodParametersAttrInfo(cf, attrNameIndex, attrLength);
            } else if ("Module".equals(attrName)) {
                ai = new ModuleAttrInfo(cf, attrNameIndex, attrLength);
            } else if ("ModulePackages".equals(attrName)) {
                ai = new ModulePackagesAttrInfo(cf, attrNameIndex, attrLength);
            } else if ("ModuleMainClass".equals(attrName)) {
                ai = new ModuleMainClassAttrInfo(cf, attrNameIndex, attrLength);
            } else if ("NestHost".equals(attrName)) {
                ai = new NestHostAttrInfo(cf, attrNameIndex, attrLength);
            } else if ("NestMembers".equals(attrName)) {
                ai = new NestMembersAttrInfo(cf, attrNameIndex, attrLength);
            } else if ("SourceDebugExtension".equals(attrName)) {
                ai = new AttrInfo(cf, attrNameIndex, attrLength);
            } else {
                if (attrLength > 0) {
                    Logger.getInstance().warning("Unrecognized attribute '" + attrName + "' in " + Conversion.toJavaClass(cf.getName()));
                }
                ai = new AttrInfo(cf, attrNameIndex, attrLength);
            }
        } else {
            throw new ParseException("Inconsistent reference to Constant Pool.");
        }
        ((AttrInfo)ai).readInfo(din);
        return ai;
    }

    protected AttrInfo(ClassFile cf, int attrNameIndex, int attrLength) {
        this.owner = cf;
        this.u2attrNameIndex = attrNameIndex;
        this.u4attrLength = attrLength;
    }

    protected int getAttrNameIndex() {
        return this.u2attrNameIndex;
    }

    protected int getAttrInfoLength() {
        return this.u4attrLength;
    }

    protected String getAttrName() {
        return "Unknown";
    }

    protected void trimAttrsExcept(String[] keepAttrs) {
    }

    protected void markUtf8Refs(ConstantPool pool) {
        pool.incRefCount(this.u2attrNameIndex);
        this.markUtf8RefsInInfo(pool);
    }

    protected void markUtf8RefsInInfo(ConstantPool pool) {
    }

    protected void readInfo(DataInput din) throws IOException {
        this.info = new byte[this.u4attrLength];
        din.readFully(this.info);
    }

    public final void write(DataOutput dout) throws IOException {
        if (dout == null) {
            throw new IOException("No output stream was provided.");
        }
        dout.writeShort(this.u2attrNameIndex);
        dout.writeInt(this.getAttrInfoLength());
        this.writeInfo(dout);
    }

    public void writeInfo(DataOutput dout) throws IOException {
        dout.write(this.info);
    }

    public String toString() {
        return this.getAttrName() + "[" + this.getAttrInfoLength() + "]";
    }
}

