/*
 * Decompiled with CFR 0.152.
 */
package com.yworks.util.compiler;

import com.yworks.util.compiler.FileObjects;
import com.yworks.util.compiler.Streams;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.ToolProvider;

public class SimpleCompiler {
    private List options;

    public void addOption(String option) {
        if (this.options == null) {
            this.options = new ArrayList();
        }
        this.options.add(option);
    }

    public Object newInMemorySource(String typeName, String code) {
        return FileObjects.newInMemoryFileObject(typeName, code);
    }

    public Object newUrlSource(String typeName, URL url) {
        return FileObjects.newUrlFileObject(typeName, url);
    }

    public boolean compile(Iterable sources, OutputStream result) {
        try {
            return this.compileImpl(sources, result);
        }
        catch (IOException ioe) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compileImpl(Iterable sources, OutputStream result) throws IOException {
        try (JarOutputStream jos = new JarOutputStream(Streams.newGuard(result));){
            boolean bl = this.compileCore(sources, jos);
            return bl;
        }
    }

    private boolean compileCore(Iterable sources, JarOutputStream jos) {
        StringWriter compilerOut = new StringWriter();
        DiagnosticCollector dc = new DiagnosticCollector();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        JavaCompiler.CompilationTask task = compiler.getTask(compilerOut, new InMemoryFileManager(jos, compiler, dc), dc, this.options, null, sources);
        Boolean result = task.call();
        return result;
    }

    private static class StreamFileObject
    extends ForwardingJavaFileObject {
        private final JarOutputStream jos;

        StreamFileObject(JarOutputStream jos, JavaFileObject jfo) {
            super(jfo);
            this.jos = jos;
        }

        @Override
        public OutputStream openOutputStream() throws IOException {
            return Streams.newGuard(this.jos);
        }
    }

    private static final class InMemoryFileManager
    extends ForwardingJavaFileManager {
        private JarOutputStream jos;
        private boolean hasEntry;

        InMemoryFileManager(JarOutputStream jos, JavaCompiler compiler, DiagnosticCollector dc) {
            super(compiler.getStandardFileManager(dc, Locale.US, Charset.forName("UTF-8")));
            this.jos = jos;
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            this.jos.putNextEntry(new JarEntry(className.replace('.', '/') + JavaFileObject.Kind.CLASS.extension));
            return new StreamFileObject(this.jos, super.getJavaFileForOutput(location, className, kind, sibling));
        }

        @Override
        public void flush() throws IOException {
            super.flush();
            this.jos.flush();
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.jos.close();
            this.jos = null;
        }
    }
}

